/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryProperties;
import com.azure.resourcemanager.containerregistry.models.EncryptionProperty;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleBypassOptions;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.azure.resourcemanager.containerregistry.models.Policies;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerregistry.models.Sku;
import com.azure.resourcemanager.containerregistry.models.Status;
import com.azure.resourcemanager.containerregistry.models.ZoneRedundancy;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class RegistryInner
extends Resource {
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="identity")
    private IdentityProperties identity;
    @JsonProperty(value="properties")
    private RegistryProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    private static final ClientLogger LOGGER = new ClientLogger(RegistryInner.class);

    public Sku sku() {
        return this.sku;
    }

    public RegistryInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public IdentityProperties identity() {
        return this.identity;
    }

    public RegistryInner withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    private RegistryProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public RegistryInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RegistryInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String loginServer() {
        return this.innerProperties() == null ? null : this.innerProperties().loginServer();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Status status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public Boolean adminUserEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().adminUserEnabled();
    }

    public RegistryInner withAdminUserEnabled(Boolean adminUserEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withAdminUserEnabled(adminUserEnabled);
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleSet();
    }

    public RegistryInner withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withNetworkRuleSet(networkRuleSet);
        return this;
    }

    public Policies policies() {
        return this.innerProperties() == null ? null : this.innerProperties().policies();
    }

    public RegistryInner withPolicies(Policies policies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withPolicies(policies);
        return this;
    }

    public EncryptionProperty encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public RegistryInner withEncryption(EncryptionProperty encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public Boolean dataEndpointEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEndpointEnabled();
    }

    public RegistryInner withDataEndpointEnabled(Boolean dataEndpointEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withDataEndpointEnabled(dataEndpointEnabled);
        return this;
    }

    public List<String> dataEndpointHostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEndpointHostNames();
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public RegistryInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public NetworkRuleBypassOptions networkRuleBypassOptions() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleBypassOptions();
    }

    public RegistryInner withNetworkRuleBypassOptions(NetworkRuleBypassOptions networkRuleBypassOptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withNetworkRuleBypassOptions(networkRuleBypassOptions);
        return this;
    }

    public ZoneRedundancy zoneRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundancy();
    }

    public RegistryInner withZoneRedundancy(ZoneRedundancy zoneRedundancy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withZoneRedundancy(zoneRedundancy);
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model RegistryInner"));
        }
        this.sku().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

