/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPodIdentityProvisioningInfo;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPodIdentityProvisioningState;
import com.azure.resourcemanager.containerservice.models.UserAssignedIdentity;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ManagedClusterPodIdentity {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="namespace", required=true)
    private String namespace;
    @JsonProperty(value="bindingSelector")
    private String bindingSelector;
    @JsonProperty(value="identity", required=true)
    private UserAssignedIdentity identity;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ManagedClusterPodIdentityProvisioningState provisioningState;
    @JsonProperty(value="provisioningInfo", access=JsonProperty.Access.WRITE_ONLY)
    private ManagedClusterPodIdentityProvisioningInfo provisioningInfo;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterPodIdentity.class);

    public String name() {
        return this.name;
    }

    public ManagedClusterPodIdentity withName(String name) {
        this.name = name;
        return this;
    }

    public String namespace() {
        return this.namespace;
    }

    public ManagedClusterPodIdentity withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String bindingSelector() {
        return this.bindingSelector;
    }

    public ManagedClusterPodIdentity withBindingSelector(String bindingSelector) {
        this.bindingSelector = bindingSelector;
        return this;
    }

    public UserAssignedIdentity identity() {
        return this.identity;
    }

    public ManagedClusterPodIdentity withIdentity(UserAssignedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public ManagedClusterPodIdentityProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ManagedClusterPodIdentityProvisioningInfo provisioningInfo() {
        return this.provisioningInfo;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model ManagedClusterPodIdentity"));
        }
        if (this.namespace() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property namespace in model ManagedClusterPodIdentity"));
        }
        if (this.identity() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property identity in model ManagedClusterPodIdentity"));
        }
        this.identity().validate();
        if (this.provisioningInfo() != null) {
            this.provisioningInfo().validate();
        }
    }
}

