/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.filter;

import com.azure.spring.cloud.autoconfigure.aad.filter.UserPrincipal;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadAuthenticationProperties;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadAuthorizationServerEndpoints;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.jwk.source.JWKSetCache;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPrincipalManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserPrincipalManager.class);
    private static final String LOGIN_MICROSOFT_ONLINE_ISSUER = "https://login.microsoftonline.com/";
    private static final String STS_WINDOWS_ISSUER = "https://sts.windows.net/";
    private static final String STS_CHINA_CLOUD_API_ISSUER = "https://sts.chinacloudapi.cn/";
    private static final String MSG_MALFORMED_AD_KEY_DISCOVERY_URI = "Failed to parse active directory key discovery uri.";
    private final JWKSource<SecurityContext> keySource;
    private final AadAuthenticationProperties aadAuthenticationProperties;
    private final boolean explicitAudienceCheck;
    private final Set<String> validAudiences = new HashSet<String>();

    public UserPrincipalManager(JWKSource<SecurityContext> keySource) {
        this.keySource = keySource;
        this.explicitAudienceCheck = false;
        this.aadAuthenticationProperties = null;
    }

    public UserPrincipalManager(AadAuthorizationServerEndpoints endpoints, AadAuthenticationProperties aadAuthenticationProperties, ResourceRetriever resourceRetriever, boolean explicitAudienceCheck) {
        this.aadAuthenticationProperties = aadAuthenticationProperties;
        this.explicitAudienceCheck = explicitAudienceCheck;
        if (explicitAudienceCheck) {
            this.validAudiences.add(this.aadAuthenticationProperties.getCredential().getClientId());
            this.validAudiences.add(this.aadAuthenticationProperties.getAppIdUri());
        }
        try {
            String jwkSetEndpoint = endpoints.getJwkSetEndpoint();
            this.keySource = new RemoteJWKSet(new URL(jwkSetEndpoint), resourceRetriever);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(MSG_MALFORMED_AD_KEY_DISCOVERY_URI, e);
        }
    }

    public UserPrincipalManager(AadAuthorizationServerEndpoints endpoints, AadAuthenticationProperties aadAuthenticationProperties, ResourceRetriever resourceRetriever, boolean explicitAudienceCheck, JWKSetCache jwkSetCache) {
        this.aadAuthenticationProperties = aadAuthenticationProperties;
        this.explicitAudienceCheck = explicitAudienceCheck;
        if (explicitAudienceCheck) {
            this.validAudiences.add(this.aadAuthenticationProperties.getCredential().getClientId());
            this.validAudiences.add(this.aadAuthenticationProperties.getAppIdUri());
        }
        try {
            String jwkSetEndpoint = endpoints.getJwkSetEndpoint();
            this.keySource = new RemoteJWKSet(new URL(jwkSetEndpoint), resourceRetriever, jwkSetCache);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(MSG_MALFORMED_AD_KEY_DISCOVERY_URI, e);
        }
    }

    public UserPrincipal buildUserPrincipal(String aadIssuedBearerToken) throws ParseException, JOSEException, BadJOSEException {
        JWSObject jwsObject = JWSObject.parse((String)aadIssuedBearerToken);
        ConfigurableJWTProcessor<SecurityContext> validator = this.getValidator(jwsObject.getHeader().getAlgorithm());
        JWTClaimsSet jwtClaimsSet = validator.process(aadIssuedBearerToken, null);
        validator.getJWTClaimsSetVerifier().verify(jwtClaimsSet, null);
        UserPrincipal userPrincipal = new UserPrincipal(aadIssuedBearerToken, jwsObject, jwtClaimsSet);
        userPrincipal.setRoles(this.getRoles(jwtClaimsSet));
        return userPrincipal;
    }

    Set<String> getRoles(JWTClaimsSet set) {
        if (set == null) {
            return Collections.emptySet();
        }
        Object rolesClaim = set.getClaim("roles");
        if (rolesClaim == null) {
            return Collections.emptySet();
        }
        if (rolesClaim instanceof Iterable) {
            return StreamSupport.stream(((Iterable)rolesClaim).spliterator(), false).map(Object::toString).collect(Collectors.toSet());
        }
        return Stream.of(rolesClaim).map(Object::toString).collect(Collectors.toSet());
    }

    public boolean isTokenIssuedByAad(String token) {
        try {
            JWT jwt = JWTParser.parse((String)token);
            return UserPrincipalManager.isAadIssuer(jwt.getJWTClaimsSet().getIssuer());
        }
        catch (ParseException e) {
            LOGGER.info("Fail to parse JWT {}, exception {}", (Object)token, (Object)e);
            return false;
        }
    }

    private static boolean isAadIssuer(String issuer) {
        if (issuer == null) {
            return false;
        }
        return issuer.startsWith(LOGIN_MICROSOFT_ONLINE_ISSUER) || issuer.startsWith(STS_WINDOWS_ISSUER) || issuer.startsWith(STS_CHINA_CLOUD_API_ISSUER);
    }

    private ConfigurableJWTProcessor<SecurityContext> getValidator(JWSAlgorithm jwsAlgorithm) {
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(jwsAlgorithm, this.keySource);
        jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
        jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier<SecurityContext>(){

            public void verify(JWTClaimsSet claimsSet, SecurityContext ctx) throws BadJWTException {
                super.verify(claimsSet, ctx);
                String issuer = claimsSet.getIssuer();
                if (!UserPrincipalManager.isAadIssuer(issuer)) {
                    throw new BadJWTException("Invalid token issuer");
                }
                if (UserPrincipalManager.this.explicitAudienceCheck) {
                    Optional<String> matchedAudience = claimsSet.getAudience().stream().filter(UserPrincipalManager.this.validAudiences::contains).findFirst();
                    if (matchedAudience.isPresent()) {
                        LOGGER.debug("Matched audience: [{}]", (Object)matchedAudience.get());
                    } else {
                        throw new BadJWTException("Invalid token audience. Provided value " + claimsSet.getAudience() + "does not match neither client-id nor AppIdUri.");
                    }
                }
            }
        });
        return jwtProcessor;
    }
}

