/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation.jwt;

import com.azure.spring.cloud.autoconfigure.aad.AadTrustedIssuerRepository;
import com.azure.spring.cloud.autoconfigure.aad.implementation.AadRestTemplateCreator;
import com.azure.spring.cloud.autoconfigure.aad.implementation.jwt.AadJwtDecoderProviderConfiguration;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JWSAlgorithmFamilyJWSKeySelector;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.JWTClaimsSetAwareJWSKeySelector;
import java.net.URL;
import java.security.Key;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.web.client.RestOperations;

public class AadIssuerJwsKeySelector
implements JWTClaimsSetAwareJWSKeySelector<SecurityContext> {
    private final AadTrustedIssuerRepository trustedIssuerRepo;
    private final Map<String, JWSKeySelector<SecurityContext>> selectors = new ConcurrentHashMap<String, JWSKeySelector<SecurityContext>>();
    private final RestOperations restOperations;
    private final ResourceRetriever resourceRetriever;

    public AadIssuerJwsKeySelector(RestTemplateBuilder restTemplateBuilder, AadTrustedIssuerRepository trustedIssuerRepo, ResourceRetriever resourceRetriever) {
        this.restOperations = AadRestTemplateCreator.createRestTemplate(restTemplateBuilder);
        this.trustedIssuerRepo = trustedIssuerRepo;
        this.resourceRetriever = resourceRetriever;
    }

    public List<? extends Key> selectKeys(JWSHeader header, JWTClaimsSet claimsSet, SecurityContext context) throws KeySourceException {
        String iss = (String)claimsSet.getClaim("iss");
        if (this.trustedIssuerRepo.isTrusted(iss)) {
            return this.selectors.computeIfAbsent(iss, this::fromIssuer).selectJWSKeys(header, context);
        }
        throw new IllegalArgumentException("The issuer: '" + iss + "' is not registered in trusted issuer repository, so cannot create JWSKeySelector.");
    }

    private JWSKeySelector<SecurityContext> fromIssuer(String issuer) {
        Map<String, Object> configurationForOidcIssuerLocation = AadJwtDecoderProviderConfiguration.getConfigurationForOidcIssuerLocation(this.restOperations, this.getOidcIssuerLocation(issuer));
        String uri = configurationForOidcIssuerLocation.get("jwks_uri").toString();
        try {
            RemoteJWKSet jwkSource = new RemoteJWKSet(new URL(uri), this.resourceRetriever);
            return JWSAlgorithmFamilyJWSKeySelector.fromJWKSource((JWKSource)jwkSource);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    private String getOidcIssuerLocation(String issuer) {
        if (this.trustedIssuerRepo.hasSpecialOidcIssuerLocation(issuer)) {
            return this.trustedIssuerRepo.getSpecialOidcIssuerLocation(issuer);
        }
        return issuer;
    }
}

