/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.condition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.MultiValueMap;

abstract class PropertyCondition
extends SpringBootCondition {
    public static final String PROPERTY_SUFFIX = ".";

    PropertyCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        List<AnnotationAttributes> allAnnotationAttributes = this.annotationAttributesFromMultiValueMap((MultiValueMap<String, Object>)metadata.getAllAnnotationAttributes(this.getAnnotationName()));
        ArrayList noMatch = new ArrayList();
        ArrayList<ConditionMessage> match = new ArrayList<ConditionMessage>();
        for (AnnotationAttributes annotationAttributes : allAnnotationAttributes) {
            ConditionOutcome outcome = this.determineOutcome(annotationAttributes, (PropertyResolver)context.getEnvironment());
            (outcome.isMatch() ? match : noMatch).add(outcome.getConditionMessage());
        }
        if (!noMatch.isEmpty()) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.of(noMatch));
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.of(match));
    }

    protected abstract ConditionOutcome determineOutcome(AnnotationAttributes var1, PropertyResolver var2);

    protected abstract String getAnnotationName();

    protected List<AnnotationAttributes> annotationAttributesFromMultiValueMap(MultiValueMap<String, Object> multiValueMap) {
        ArrayList maps = new ArrayList();
        if (multiValueMap != null) {
            multiValueMap.forEach((key, value) -> {
                for (int i = 0; i < value.size(); ++i) {
                    Map map;
                    if (i < maps.size()) {
                        map = (Map)maps.get(i);
                    } else {
                        map = new HashMap();
                        maps.add(map);
                    }
                    map.put((String)key, value.get(i));
                }
            });
        }
        ArrayList<AnnotationAttributes> annotationAttributes = new ArrayList<AnnotationAttributes>(maps.size());
        for (Map map : maps) {
            annotationAttributes.add(AnnotationAttributes.fromMap((Map)map));
        }
        return annotationAttributes;
    }
}

