/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.servicebus;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.implementation.servicebus.AzureServiceBusProcessorCondition;
import com.azure.spring.cloud.autoconfigure.implementation.servicebus.properties.AzureServiceBusProperties;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import com.azure.spring.cloud.service.implementation.servicebus.factory.ServiceBusProcessorClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.servicebus.factory.ServiceBusSessionProcessorClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.servicebus.lifecycle.ServiceBusProcessorClientLifecycleManager;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusProcessorClientProperties;
import com.azure.spring.cloud.service.listener.MessageListener;
import com.azure.spring.cloud.service.servicebus.consumer.ServiceBusErrorHandler;
import com.azure.spring.cloud.service.servicebus.consumer.ServiceBusRecordMessageListener;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={ServiceBusRecordMessageListener.class, ServiceBusErrorHandler.class})
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.servicebus", name={"entity-name", "processor.entity-name"})
@Import(value={SessionProcessorClientConfiguration.class, NoneSessionProcessorClientConfiguration.class})
@Conditional(value={AzureServiceBusProcessorCondition.class})
class AzureServiceBusProcessorClientConfiguration {
    AzureServiceBusProcessorClientConfiguration() {
    }

    @Bean
    @ConditionalOnBean(value={ServiceBusProcessorClient.class})
    @ConditionalOnMissingBean(value={ServiceBusProcessorClientLifecycleManager.class})
    @ConditionalOnProperty(value={"spring.cloud.azure.servicebus.processor.auto-startup"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnClass(value={ServiceBusProcessorClientLifecycleManager.class})
    ServiceBusProcessorClientLifecycleManager processorClientLifecycleManager(ServiceBusProcessorClient processorClient) {
        return new ServiceBusProcessorClientLifecycleManager(processorClient);
    }

    private static boolean isDedicatedConnection(AzureServiceBusProperties.Processor processor) {
        return StringUtils.hasText((String)processor.getNamespace()) || StringUtils.hasText((String)processor.getConnectionString());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.azure.servicebus.processor.session-enabled"}, havingValue="true")
    static class SessionProcessorClientConfiguration {
        SessionProcessorClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ServiceBusSessionProcessorClientBuilderFactory serviceBusSessionProcessorClientBuilderFactory(AzureServiceBusProperties serviceBusProperties, ServiceBusRecordMessageListener messageListener, ServiceBusErrorHandler errorHandler, ObjectProvider<ServiceBusClientBuilder> serviceBusClientBuilders, ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder>> customizers) {
            ServiceBusSessionProcessorClientBuilderFactory factory = AzureServiceBusProcessorClientConfiguration.isDedicatedConnection(serviceBusProperties.getProcessor()) ? new ServiceBusSessionProcessorClientBuilderFactory((ServiceBusProcessorClientProperties)serviceBusProperties.buildProcessorProperties(), (MessageListener)messageListener, errorHandler) : new ServiceBusSessionProcessorClientBuilderFactory((ServiceBusClientBuilder)serviceBusClientBuilders.getIfAvailable(), (ServiceBusProcessorClientProperties)serviceBusProperties.buildProcessorProperties(), (MessageListener)messageListener, errorHandler);
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_SERVICE_BUS);
            connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((ServiceBusSessionProcessorClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
            customizers.orderedStream().forEach(arg_0 -> ((ServiceBusSessionProcessorClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
            return factory;
        }

        @Bean
        @ConditionalOnMissingBean
        ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder serviceBusSessionProcessorClientBuilder(ServiceBusSessionProcessorClientBuilderFactory builderFactory) {
            return (ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builderFactory.build();
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusProcessorClient serviceBusProcessorClient(ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder processorClientBuilder) {
            return processorClientBuilder.buildProcessorClient();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.azure.servicebus.processor.session-enabled"}, havingValue="false", matchIfMissing=true)
    static class NoneSessionProcessorClientConfiguration {
        NoneSessionProcessorClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ServiceBusProcessorClientBuilderFactory serviceBusProcessorClientBuilderFactory(AzureServiceBusProperties serviceBusProperties, ServiceBusRecordMessageListener messageListener, ServiceBusErrorHandler errorHandler, ObjectProvider<ServiceBusClientBuilder> serviceBusClientBuilders, ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusProcessorClientBuilder>> customizers) {
            ServiceBusProcessorClientBuilderFactory factory = AzureServiceBusProcessorClientConfiguration.isDedicatedConnection(serviceBusProperties.getProcessor()) ? new ServiceBusProcessorClientBuilderFactory((ServiceBusProcessorClientProperties)serviceBusProperties.buildProcessorProperties(), (MessageListener)messageListener, errorHandler) : new ServiceBusProcessorClientBuilderFactory((ServiceBusClientBuilder)serviceBusClientBuilders.getIfAvailable(), (ServiceBusProcessorClientProperties)serviceBusProperties.buildProcessorProperties(), (MessageListener)messageListener, errorHandler);
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_SERVICE_BUS);
            connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((ServiceBusProcessorClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
            customizers.orderedStream().forEach(arg_0 -> ((ServiceBusProcessorClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
            return factory;
        }

        @Bean
        @ConditionalOnMissingBean
        ServiceBusClientBuilder.ServiceBusProcessorClientBuilder serviceBusProcessorClientBuilder(ServiceBusProcessorClientBuilderFactory builderFactory) {
            return (ServiceBusClientBuilder.ServiceBusProcessorClientBuilder)builderFactory.build();
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusProcessorClient serviceBusProcessorClient(ServiceBusClientBuilder.ServiceBusProcessorClientBuilder processorClientBuilder) {
            return processorClientBuilder.buildProcessorClient();
        }
    }
}

