/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.servicebus.factory;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.service.implementation.servicebus.factory.AbstractServiceBusSubClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusProcessorClientProperties;
import com.azure.spring.cloud.service.listener.MessageListener;
import com.azure.spring.cloud.service.servicebus.consumer.ServiceBusErrorHandler;
import com.azure.spring.cloud.service.servicebus.consumer.ServiceBusRecordMessageListener;
import com.azure.spring.cloud.service.servicebus.properties.ServiceBusEntityType;
import java.util.List;
import org.springframework.util.Assert;

public class ServiceBusSessionProcessorClientBuilderFactory
extends AbstractServiceBusSubClientBuilderFactory<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder, ServiceBusProcessorClientProperties> {
    private final MessageListener<?> messageListener;
    private final ServiceBusErrorHandler errorHandler;

    public ServiceBusSessionProcessorClientBuilderFactory(ServiceBusProcessorClientProperties properties, List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder>> serviceBusClientBuilderCustomizers, MessageListener<?> messageListener, ServiceBusErrorHandler errorHandler) {
        this(null, properties, serviceBusClientBuilderCustomizers, messageListener, errorHandler);
    }

    public ServiceBusSessionProcessorClientBuilderFactory(ServiceBusClientBuilder serviceBusClientBuilder, ServiceBusProcessorClientProperties properties, MessageListener<?> processingListener, ServiceBusErrorHandler errorHandler) {
        this(serviceBusClientBuilder, properties, null, processingListener, errorHandler);
    }

    private ServiceBusSessionProcessorClientBuilderFactory(ServiceBusClientBuilder serviceBusClientBuilder, ServiceBusProcessorClientProperties properties, List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder>> serviceBusClientBuilderCustomizers, MessageListener<?> messageListener, ServiceBusErrorHandler errorHandler) {
        super(serviceBusClientBuilder, properties, serviceBusClientBuilderCustomizers);
        this.messageListener = messageListener;
        this.errorHandler = errorHandler;
    }

    protected ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder createBuilderInstance() {
        return this.getServiceBusClientBuilder().sessionProcessor();
    }

    @Override
    protected void configureService(ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder builder) {
        Assert.notNull((Object)((Object)((ServiceBusProcessorClientProperties)this.properties).getEntityType()), (String)"Entity type cannot be null.");
        Assert.notNull((Object)((ServiceBusProcessorClientProperties)this.properties).getEntityName(), (String)"Entity name cannot be null.");
        super.configureService(builder);
        PropertyMapper propertyMapper = new PropertyMapper();
        if (ServiceBusEntityType.QUEUE == ((ServiceBusProcessorClientProperties)this.properties).getEntityType()) {
            propertyMapper.from((Object)((ServiceBusProcessorClientProperties)this.properties).getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).queueName(arg_0));
        } else if (ServiceBusEntityType.TOPIC == ((ServiceBusProcessorClientProperties)this.properties).getEntityType()) {
            propertyMapper.from((Object)((ServiceBusProcessorClientProperties)this.properties).getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).topicName(arg_0));
        }
        propertyMapper.from((Object)((ServiceBusProcessorClientProperties)this.properties).getSubscriptionName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).subscriptionName(arg_0));
        propertyMapper.from((Object)((ServiceBusProcessorClientProperties)this.properties).getReceiveMode()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).receiveMode(arg_0));
        propertyMapper.from((Object)((ServiceBusProcessorClientProperties)this.properties).getSubQueue()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).subQueue(arg_0));
        propertyMapper.from((Object)((ServiceBusProcessorClientProperties)this.properties).getPrefetchCount()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).prefetchCount(arg_0));
        propertyMapper.from((Object)((ServiceBusProcessorClientProperties)this.properties).getMaxAutoLockRenewDuration()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).maxAutoLockRenewDuration(arg_0));
        propertyMapper.from((Object)((ServiceBusProcessorClientProperties)this.properties).getAutoComplete()).whenFalse().to(t -> builder.disableAutoComplete());
        propertyMapper.from((Object)((ServiceBusProcessorClientProperties)this.properties).getMaxConcurrentCalls()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).maxConcurrentCalls(arg_0));
        propertyMapper.from((Object)((ServiceBusProcessorClientProperties)this.properties).getMaxConcurrentSessions()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).maxConcurrentSessions(arg_0));
        propertyMapper.from((Object)this.errorHandler).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).processError(arg_0));
        this.configureProcessorListener(builder);
    }

    private void configureProcessorListener(ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder builder) {
        if (!(this.messageListener instanceof ServiceBusRecordMessageListener)) {
            throw new IllegalArgumentException("Listener must be a '" + ServiceBusRecordMessageListener.class.getSimpleName() + "' not " + this.messageListener.getClass().getName());
        }
        builder.processMessage(((ServiceBusRecordMessageListener)this.messageListener)::onMessage);
    }
}

