/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.plugin.transform;

import dagger.hilt.android.plugin.root.AggregatedAnnotation;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b'\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t"}, d2={"Ldagger/hilt/android/plugin/transform/AggregatedPackagesTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lorg/gradle/api/artifacts/transform/TransformParameters$None;", "<init>", "()V", "inputArtifactProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifactProvider", "()Lorg/gradle/api/provider/Provider;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "transformFile", "file", "Ljava/io/File;", "Companion"})
@SourceDebugExtension(value={"SMAP\nAggregatedPackagesTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AggregatedPackagesTransform.kt\ndagger/hilt/android/plugin/transform/AggregatedPackagesTransform\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1295#2,2:104\n1#3:106\n1747#4,3:107\n1747#4,3:110\n*S KotlinDebug\n*F\n+ 1 AggregatedPackagesTransform.kt\ndagger/hilt/android/plugin/transform/AggregatedPackagesTransform\n*L\n53#1:104,2\n89#1:107,3\n69#1:110,3\n*E\n"})
public abstract class AggregatedPackagesTransform
implements TransformAction<TransformParameters.None> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String JAR_NAME = "hiltAggregated.jar";

    @Classpath
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifactProvider();

    public void transform(@NotNull TransformOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        File input = ((FileSystemLocation)this.getInputArtifactProvider().get()).getAsFile();
        if (input.isFile()) {
            Intrinsics.checkNotNull((Object)input);
            this.transformFile(outputs, input);
        } else if (input.isDirectory()) {
            Intrinsics.checkNotNull((Object)input);
            Sequence $this$forEach$iv = SequencesKt.filter(dagger.hilt.android.plugin.util.FilesKt.walkInPlatformIndependentOrder(input), AggregatedPackagesTransform::transform$lambda$0);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                this.transformFile(outputs, it);
            }
        } else {
            throw new IllegalStateException(("File/directory does not exist: " + input.getAbsolutePath()).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void transformFile(TransformOutputs outputs, File file) {
        if (dagger.hilt.android.plugin.util.FilesKt.isJarFile(file)) {
            Ref.BooleanRef atLeastOneEntry = new Ref.BooleanRef();
            ByteArrayOutputStream tmpOutputStream = new ByteArrayOutputStream();
            Object object = new ZipOutputStream(tmpOutputStream);
            Throwable throwable = null;
            try {
                ZipOutputStream outputStream = (ZipOutputStream)object;
                boolean bl = false;
                dagger.hilt.android.plugin.util.FilesKt.forEachZipEntry(new ZipInputStream(new FileInputStream(file)), (Function2<? super InputStream, ? super ZipEntry, Unit>)((Function2)(arg_0, arg_1) -> AggregatedPackagesTransform.transformFile$lambda$4$lambda$3(outputStream, atLeastOneEntry, arg_0, arg_1)));
                outputStream = Unit.INSTANCE;
            }
            catch (Throwable outputStream) {
                throwable = outputStream;
                throw outputStream;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            if (atLeastOneEntry.element) {
                File file2 = outputs.file((Object)JAR_NAME);
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file(...)");
                object = file2;
                object = new FileOutputStream((File)object);
                throwable = null;
                try {
                    FileOutputStream it = (FileOutputStream)object;
                    boolean bl = false;
                    tmpOutputStream.writeTo(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        } else if (dagger.hilt.android.plugin.util.FilesKt.isClassFile(file)) {
            boolean match;
            block19: {
                File file3 = file.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getParentFile(...)");
                File parentDirectory = file3;
                Iterable $this$any$iv = AggregatedAnnotation.Companion.getAGGREGATED_PACKAGES();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String aggregatedPackage = (String)element$iv;
                        boolean bl = false;
                        if (!FilesKt.endsWith((File)parentDirectory, (String)aggregatedPackage)) continue;
                        v2 = true;
                        break block19;
                    }
                    v2 = match = false;
                }
            }
            if (match) {
                outputs.file((Object)file);
            }
        }
    }

    private static final boolean transform$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile();
    }

    private static final Unit transformFile$lambda$4$lambda$3(ZipOutputStream $outputStream, Ref.BooleanRef $atLeastOneEntry, InputStream inputStream, ZipEntry inputEntry) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)inputEntry, (String)"inputEntry");
        if (dagger.hilt.android.plugin.util.FilesKt.isClassFile(inputEntry)) {
            boolean match;
            block5: {
                String string = inputEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String parentDirectory = StringsKt.substringBeforeLast$default((String)string, (char)'/', null, (int)2, null);
                Iterable $this$any$iv = AggregatedAnnotation.Companion.getAGGREGATED_PACKAGES();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String aggregatedPackage = (String)element$iv;
                        boolean bl = false;
                        if (!StringsKt.endsWith$default((String)parentDirectory, (String)aggregatedPackage, (boolean)false, (int)2, null)) continue;
                        v1 = true;
                        break block5;
                    }
                    v1 = match = false;
                }
            }
            if (match) {
                $outputStream.putNextEntry(new ZipEntry(inputEntry.getName()));
                ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)$outputStream, (int)0, (int)2, null);
                $outputStream.closeEntry();
                $atLeastOneEntry.element = true;
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007"}, d2={"Ldagger/hilt/android/plugin/transform/AggregatedPackagesTransform$Companion;", "", "<init>", "()V", "JAR_NAME", "", "getJAR_NAME", "()Ljava/lang/String;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getJAR_NAME() {
            return JAR_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

