/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.base64.Base64;
import com.helger.commons.base64.Base64InputStream;
import com.helger.commons.base64.Base64OutputStream;
import com.helger.commons.codec.DecodeException;
import com.helger.commons.codec.EncodeException;
import com.helger.commons.codec.IByteArrayCodec;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonClosingOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.math.MathHelper;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public class Base64Codec
implements IByteArrayCodec {
    @Override
    public int getEncodedLength(int n) {
        return MathHelper.getRoundedUp(n * 4 / 3, 4);
    }

    @Override
    public void encode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try (Base64OutputStream base64OutputStream = new Base64OutputStream(new NonClosingOutputStream(outputStream));){
            base64OutputStream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new EncodeException("Failed to encode Base64", iOException);
        }
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public byte[] getEncoded(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return Base64.safeEncodeBytesToBytes(byArray, n, n2);
    }

    @Override
    public int getDecodedLength(int n) {
        return MathHelper.getRoundedUp(n, 4) * 3 / 4;
    }

    @Override
    public void decode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray != null) {
            try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray, n, n2);
                 Base64InputStream base64InputStream = new Base64InputStream(nonBlockingByteArrayInputStream);){
                if (StreamHelper.copyInputStreamToOutputStream(base64InputStream, outputStream).isFailure()) {
                    throw new DecodeException("Failed to decode Base64!");
                }
            }
            catch (IOException iOException) {
                throw new DecodeException("Failed to decode Base64!", iOException);
            }
        }
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public byte[] getDecoded(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return Base64.safeDecode(byArray, n, n2);
    }
}

