/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.model;

import com.opera.core.systems.model.ColorResult;
import java.util.List;

public class ScreenCaptureReply {
    private String md5 = null;
    private byte[] png = null;
    private boolean blank = false;
    private boolean crashed = false;
    protected List<ColorResult> colorResults;

    public ScreenCaptureReply() {
        this.md5 = null;
        this.png = null;
    }

    public ScreenCaptureReply(String md5) {
        this.md5 = md5;
        this.png = null;
    }

    public ScreenCaptureReply(String md5, byte[] png) {
        this.md5 = md5;
        this.png = (byte[])png.clone();
    }

    public ScreenCaptureReply(String md5, List<ColorResult> colorResult) {
        this.md5 = md5;
        this.colorResults = colorResult;
        this.png = null;
    }

    public String getMd5() {
        return this.md5;
    }

    public byte[] getPng() {
        return this.png;
    }

    public List<ColorResult> getColorResults() {
        return this.colorResults;
    }

    public boolean isBlank() {
        return this.blank;
    }

    public boolean isCrashed() {
        return this.crashed;
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ byte[] access$102(ScreenCaptureReply x0, byte[] x1) {
        x0.png = x1;
        return x1;
    }

    public static class Builder {
        private final ScreenCaptureReply reply = new ScreenCaptureReply();

        public Builder setMD5(String md5) {
            this.reply.md5 = md5;
            return this;
        }

        public Builder setPNG(byte[] data) {
            if (data != null) {
                ScreenCaptureReply.access$102(this.reply, (byte[])data.clone());
            } else {
                ScreenCaptureReply.access$102(this.reply, null);
            }
            return this;
        }

        public Builder setColorResult(List<ColorResult> colorResults) {
            this.reply.colorResults = colorResults;
            return this;
        }

        public Builder setBlank(boolean blank) {
            this.reply.blank = blank;
            return this;
        }

        public Builder setCrashed(boolean crashed) {
            this.reply.crashed = crashed;
            return this;
        }

        public ScreenCaptureReply build() {
            if (this.reply.blank) {
                this.setPNG(null);
            }
            return this.reply;
        }
    }
}

