/*
 * Decompiled with CFR 0.152.
 */
package mockwebserver3;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mockwebserver3.Dispatcher;
import mockwebserver3.MockResponse;
import mockwebserver3.RecordedRequest;
import okhttp3.ExperimentalOkHttpApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0013\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lmockwebserver3/QueueDispatcher;", "Lmockwebserver3/Dispatcher;", "<init>", "()V", "responseQueue", "Ljava/util/concurrent/BlockingQueue;", "Lmockwebserver3/MockResponse;", "getResponseQueue", "()Ljava/util/concurrent/BlockingQueue;", "failFastResponse", "dispatch", "request", "Lmockwebserver3/RecordedRequest;", "peek", "enqueueResponse", "", "response", "clear", "shutdown", "setFailFast", "failFast", "", "Companion", "mockwebserver3"})
@ExperimentalOkHttpApi
public class QueueDispatcher
extends Dispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockingQueue<MockResponse> responseQueue = new LinkedBlockingQueue();
    @Nullable
    private MockResponse failFastResponse;
    @NotNull
    private static final MockResponse DEAD_LETTER = new MockResponse(503, null, null, false, null, 30, null);
    private static final Logger logger = Logger.getLogger(QueueDispatcher.class.getName());

    @NotNull
    protected final BlockingQueue<MockResponse> getResponseQueue() {
        return this.responseQueue;
    }

    @Override
    @NotNull
    public MockResponse dispatch(@NotNull RecordedRequest request) throws InterruptedException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String requestLine = request.getRequestLine();
        if (Intrinsics.areEqual((Object)requestLine, (Object)"GET /favicon.ico HTTP/1.1")) {
            logger.info("served " + requestLine);
            return new MockResponse(404, null, null, false, null, 30, null);
        }
        if (this.failFastResponse != null && this.responseQueue.peek() == null) {
            MockResponse mockResponse = this.failFastResponse;
            Intrinsics.checkNotNull((Object)mockResponse);
            return mockResponse;
        }
        MockResponse result = this.responseQueue.take();
        if (Intrinsics.areEqual((Object)result, (Object)DEAD_LETTER)) {
            this.responseQueue.add(DEAD_LETTER);
        }
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    @Override
    @NotNull
    public MockResponse peek() {
        MockResponse mockResponse = (MockResponse)this.responseQueue.peek();
        if (mockResponse == null && (mockResponse = this.failFastResponse) == null) {
            mockResponse = super.peek();
        }
        return mockResponse;
    }

    public void enqueueResponse(@NotNull MockResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.responseQueue.add(response);
    }

    public void clear() {
        this.responseQueue.clear();
    }

    @Override
    public void shutdown() {
        this.responseQueue.add(DEAD_LETTER);
    }

    public void setFailFast(boolean failFast) {
        MockResponse failFastResponse = failFast ? new MockResponse(404, null, null, false, null, 30, null) : null;
        this.setFailFast(failFastResponse);
    }

    public void setFailFast(@Nullable MockResponse failFastResponse) {
        this.failFastResponse = failFastResponse;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lmockwebserver3/QueueDispatcher$Companion;", "", "<init>", "()V", "DEAD_LETTER", "Lmockwebserver3/MockResponse;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "mockwebserver3"})
    @ExperimentalOkHttpApi
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

