/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.models.AzureChatEnhancementConfiguration;
import com.azure.ai.openai.models.AzureChatExtensionConfiguration;
import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.ChatCompletionsResponseFormat;
import com.azure.ai.openai.models.ChatResponseMessage;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.azure.AzureOpenAiStreamingResponseBuilder;
import dev.langchain4j.model.azure.AzureOpenAiTokenizer;
import dev.langchain4j.model.azure.InternalAzureOpenAiHelper;
import dev.langchain4j.model.azure.spi.AzureOpenAiStreamingChatModelBuilderFactory;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.TokenCountEstimator;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class AzureOpenAiStreamingChatModel
implements StreamingChatLanguageModel,
TokenCountEstimator {
    private static final Logger logger = LoggerFactory.getLogger(AzureOpenAiStreamingChatModel.class);
    private OpenAIClient client;
    private OpenAIAsyncClient asyncClient;
    private final String deploymentName;
    private final Tokenizer tokenizer;
    private final Integer maxTokens;
    private final Double temperature;
    private final Double topP;
    private final Map<String, Integer> logitBias;
    private final String user;
    private final List<String> stop;
    private final Double presencePenalty;
    private final Double frequencyPenalty;
    private final List<AzureChatExtensionConfiguration> dataSources;
    private final AzureChatEnhancementConfiguration enhancements;
    private final Long seed;
    @Deprecated
    private ChatCompletionsResponseFormat chatCompletionsResponseFormat;
    private final ResponseFormat responseFormat;
    private final Boolean strictJsonSchema;
    private final List<ChatModelListener> listeners;

    public AzureOpenAiStreamingChatModel(OpenAIClient client, OpenAIAsyncClient asyncClient, String deploymentName, Tokenizer tokenizer, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, List<String> stop, Double presencePenalty, Double frequencyPenalty, List<AzureChatExtensionConfiguration> dataSources, AzureChatEnhancementConfiguration enhancements, Long seed, @Deprecated ChatCompletionsResponseFormat chatCompletionsResponseFormat, ResponseFormat responseFormat, Boolean strictJsonSchema, List<ChatModelListener> listeners, Set<Capability> capabilities) {
        this(deploymentName, tokenizer, maxTokens, temperature, topP, logitBias, user, stop, presencePenalty, frequencyPenalty, dataSources, enhancements, seed, chatCompletionsResponseFormat, responseFormat, strictJsonSchema, listeners, capabilities);
        if (asyncClient != null) {
            this.asyncClient = asyncClient;
        } else if (client != null) {
            this.client = client;
        } else {
            throw new IllegalStateException("No client available");
        }
    }

    public AzureOpenAiStreamingChatModel(String endpoint, String serviceVersion, String apiKey, String deploymentName, Tokenizer tokenizer, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, List<String> stop, Double presencePenalty, Double frequencyPenalty, List<AzureChatExtensionConfiguration> dataSources, AzureChatEnhancementConfiguration enhancements, Long seed, @Deprecated ChatCompletionsResponseFormat chatCompletionsResponseFormat, ResponseFormat responseFormat, Boolean strictJsonSchema, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses, boolean useAsyncClient, List<ChatModelListener> listeners, String userAgentSuffix, Map<String, String> customHeaders, Set<Capability> capabilities) {
        this(deploymentName, tokenizer, maxTokens, temperature, topP, logitBias, user, stop, presencePenalty, frequencyPenalty, dataSources, enhancements, seed, chatCompletionsResponseFormat, responseFormat, strictJsonSchema, listeners, capabilities);
        if (useAsyncClient) {
            this.asyncClient = InternalAzureOpenAiHelper.setupAsyncClient(endpoint, serviceVersion, apiKey, timeout, maxRetries, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
        } else {
            this.client = InternalAzureOpenAiHelper.setupSyncClient(endpoint, serviceVersion, apiKey, timeout, maxRetries, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
        }
    }

    public AzureOpenAiStreamingChatModel(String endpoint, String serviceVersion, KeyCredential keyCredential, String deploymentName, Tokenizer tokenizer, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, List<String> stop, Double presencePenalty, Double frequencyPenalty, List<AzureChatExtensionConfiguration> dataSources, AzureChatEnhancementConfiguration enhancements, Long seed, @Deprecated ChatCompletionsResponseFormat chatCompletionsResponseFormat, ResponseFormat responseFormat, Boolean strictJsonSchema, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses, boolean useAsyncClient, List<ChatModelListener> listeners, String userAgentSuffix, Map<String, String> customHeaders, Set<Capability> capabilities) {
        this(deploymentName, tokenizer, maxTokens, temperature, topP, logitBias, user, stop, presencePenalty, frequencyPenalty, dataSources, enhancements, seed, chatCompletionsResponseFormat, responseFormat, strictJsonSchema, listeners, capabilities);
        if (useAsyncClient) {
            this.asyncClient = InternalAzureOpenAiHelper.setupAsyncClient(endpoint, serviceVersion, keyCredential, timeout, maxRetries, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
        } else {
            this.client = InternalAzureOpenAiHelper.setupSyncClient(endpoint, serviceVersion, keyCredential, timeout, maxRetries, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
        }
    }

    public AzureOpenAiStreamingChatModel(String endpoint, String serviceVersion, TokenCredential tokenCredential, String deploymentName, Tokenizer tokenizer, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, List<String> stop, Double presencePenalty, Double frequencyPenalty, List<AzureChatExtensionConfiguration> dataSources, AzureChatEnhancementConfiguration enhancements, Long seed, @Deprecated ChatCompletionsResponseFormat chatCompletionsResponseFormat, ResponseFormat responseFormat, Boolean strictJsonSchema, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses, boolean useAsyncClient, List<ChatModelListener> listeners, String userAgentSuffix, Map<String, String> customHeaders, Set<Capability> capabilities) {
        this(deploymentName, tokenizer, maxTokens, temperature, topP, logitBias, user, stop, presencePenalty, frequencyPenalty, dataSources, enhancements, seed, chatCompletionsResponseFormat, responseFormat, strictJsonSchema, listeners, capabilities);
        if (useAsyncClient) {
            this.asyncClient = InternalAzureOpenAiHelper.setupAsyncClient(endpoint, serviceVersion, tokenCredential, timeout, maxRetries, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
        } else {
            this.client = InternalAzureOpenAiHelper.setupSyncClient(endpoint, serviceVersion, tokenCredential, timeout, maxRetries, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
        }
    }

    private AzureOpenAiStreamingChatModel(String deploymentName, Tokenizer tokenizer, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, List<String> stop, Double presencePenalty, Double frequencyPenalty, List<AzureChatExtensionConfiguration> dataSources, AzureChatEnhancementConfiguration enhancements, Long seed, @Deprecated ChatCompletionsResponseFormat chatCompletionsResponseFormat, ResponseFormat responseFormat, Boolean strictJsonSchema, List<ChatModelListener> listeners, Set<Capability> capabilities) {
        this.deploymentName = (String)Utils.getOrDefault((Object)deploymentName, (Object)"gpt-35-turbo");
        this.tokenizer = (Tokenizer)Utils.getOrDefault((Object)tokenizer, AzureOpenAiTokenizer::new);
        this.maxTokens = maxTokens;
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.topP = topP;
        this.logitBias = logitBias;
        this.user = user;
        this.stop = stop;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.dataSources = dataSources;
        this.enhancements = enhancements;
        this.seed = seed;
        this.chatCompletionsResponseFormat = chatCompletionsResponseFormat;
        this.responseFormat = responseFormat;
        if (this.chatCompletionsResponseFormat != null && this.responseFormat != null) {
            throw new IllegalArgumentException("You can't set both chatCompletionsResponseFormat and responseFormat");
        }
        this.strictJsonSchema = (Boolean)Utils.getOrDefault((Object)strictJsonSchema, (Object)false);
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, null, null, this.responseFormat, handler);
    }

    public void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, toolSpecifications, null, this.responseFormat, handler);
    }

    public void generate(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, null, toolSpecification, this.responseFormat, handler);
    }

    public void chat(ChatRequest request, final StreamingChatResponseHandler handler) {
        ChatRequestParameters parameters = request.parameters();
        ChatLanguageModel.validate((ChatRequestParameters)parameters);
        ResponseFormat responseFormat = request.responseFormat();
        if (responseFormat == null) {
            responseFormat = this.responseFormat;
        }
        StreamingResponseHandler<AiMessage> legacyHandler = new StreamingResponseHandler<AiMessage>(){

            public void onNext(String token) {
                handler.onPartialResponse(token);
            }

            public void onComplete(Response<AiMessage> response) {
                ChatResponse chatResponse = ChatResponse.builder().aiMessage((AiMessage)response.content()).metadata(ChatResponseMetadata.builder().tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).build()).build();
                handler.onCompleteResponse(chatResponse);
            }

            public void onError(Throwable error) {
                handler.onError(error);
            }
        };
        List toolSpecifications = parameters.toolSpecifications();
        if (Utils.isNullOrEmpty((Collection)toolSpecifications)) {
            this.generate(request.messages(), null, null, responseFormat, legacyHandler);
        } else if (parameters.toolChoice() == ToolChoice.REQUIRED) {
            if (toolSpecifications.size() != 1) {
                throw new UnsupportedFeatureException("%s.%s is currently supported only when there is a single tool".formatted(ToolChoice.class.getSimpleName(), ToolChoice.REQUIRED.name()));
            }
            this.generate(request.messages(), toolSpecifications, (ToolSpecification)toolSpecifications.get(0), responseFormat, legacyHandler);
        } else {
            this.generate(request.messages(), toolSpecifications, null, responseFormat, legacyHandler);
        }
    }

    private void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted, ResponseFormat responseFormat, StreamingResponseHandler<AiMessage> handler) {
        ChatCompletionsResponseFormat chatCompletionsResponseFormat = null;
        chatCompletionsResponseFormat = responseFormat != null ? InternalAzureOpenAiHelper.toAzureOpenAiResponseFormat(responseFormat, this.strictJsonSchema) : this.chatCompletionsResponseFormat;
        ChatCompletionsOptions options = new ChatCompletionsOptions(InternalAzureOpenAiHelper.toOpenAiMessages(messages)).setModel(this.deploymentName).setMaxTokens(this.maxTokens).setTemperature(this.temperature).setTopP(this.topP).setLogitBias(this.logitBias).setUser(this.user).setStop(this.stop).setPresencePenalty(this.presencePenalty).setFrequencyPenalty(this.frequencyPenalty).setDataSources(this.dataSources).setEnhancements(this.enhancements).setSeed(this.seed).setResponseFormat(chatCompletionsResponseFormat);
        int inputTokenCount = this.tokenizer.estimateTokenCountInMessages(messages);
        if (toolThatMustBeExecuted != null) {
            options.setTools(InternalAzureOpenAiHelper.toToolDefinitions(Collections.singletonList(toolThatMustBeExecuted)));
            options.setToolChoice(InternalAzureOpenAiHelper.toToolChoice(toolThatMustBeExecuted));
            inputTokenCount += this.tokenizer.estimateTokenCountInForcefulToolSpecification(toolThatMustBeExecuted);
        }
        if (!Utils.isNullOrEmpty(toolSpecifications)) {
            options.setTools(InternalAzureOpenAiHelper.toToolDefinitions(toolSpecifications));
            inputTokenCount += this.tokenizer.estimateTokenCountInToolSpecifications(toolSpecifications);
        }
        AzureOpenAiStreamingResponseBuilder responseBuilder = new AzureOpenAiStreamingResponseBuilder(inputTokenCount);
        ChatModelRequest modelListenerRequest = InternalAzureOpenAiHelper.createModelListenerRequest(options, messages, toolSpecifications);
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(modelListenerRequest, attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                logger.warn("Exception while calling model listener", (Throwable)e);
            }
        });
        if (this.client != null) {
            this.syncCall(toolThatMustBeExecuted, handler, options, responseBuilder, requestContext);
        } else if (this.asyncClient != null) {
            this.asyncCall(toolThatMustBeExecuted, handler, options, responseBuilder, requestContext);
        }
    }

    private void asyncCall(ToolSpecification toolThatMustBeExecuted, StreamingResponseHandler<AiMessage> handler, ChatCompletionsOptions options, AzureOpenAiStreamingResponseBuilder responseBuilder, ChatModelRequestContext requestContext) {
        Flux chatCompletionsStream = this.asyncClient.getChatCompletionsStream(this.deploymentName, options);
        AtomicReference responseId = new AtomicReference();
        chatCompletionsStream.subscribe(chatCompletion -> {
            responseBuilder.append((ChatCompletions)chatCompletion);
            AzureOpenAiStreamingChatModel.handle(chatCompletion, handler);
            if (Utils.isNotNullOrBlank((String)chatCompletion.getId())) {
                responseId.set(chatCompletion.getId());
            }
        }, throwable -> {
            ChatModelErrorContext errorContext = new ChatModelErrorContext(throwable, requestContext.request(), null, requestContext.attributes());
            this.listeners.forEach(listener -> {
                try {
                    listener.onError(errorContext);
                }
                catch (Exception e2) {
                    logger.warn("Exception while calling model listener", (Throwable)e2);
                }
            });
            handler.onError(throwable);
        }, () -> {
            Response<AiMessage> response = responseBuilder.build(this.tokenizer, toolThatMustBeExecuted != null);
            ChatModelResponse modelListenerResponse = InternalAzureOpenAiHelper.createModelListenerResponse((String)responseId.get(), options.getModel(), response);
            ChatModelResponseContext responseContext = new ChatModelResponseContext(modelListenerResponse, requestContext.request(), requestContext.attributes());
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(responseContext);
                }
                catch (Exception e) {
                    logger.warn("Exception while calling model listener", (Throwable)e);
                }
            });
            handler.onComplete(response);
        });
    }

    private void syncCall(ToolSpecification toolThatMustBeExecuted, StreamingResponseHandler<AiMessage> handler, ChatCompletionsOptions options, AzureOpenAiStreamingResponseBuilder responseBuilder, ChatModelRequestContext requestContext) {
        try {
            AtomicReference responseId = new AtomicReference();
            this.client.getChatCompletionsStream(this.deploymentName, options).stream().forEach(chatCompletions -> {
                responseBuilder.append((ChatCompletions)chatCompletions);
                AzureOpenAiStreamingChatModel.handle(chatCompletions, handler);
                if (Utils.isNotNullOrBlank((String)chatCompletions.getId())) {
                    responseId.set(chatCompletions.getId());
                }
            });
            Response<AiMessage> response = responseBuilder.build(this.tokenizer, toolThatMustBeExecuted != null);
            ChatModelResponse modelListenerResponse = InternalAzureOpenAiHelper.createModelListenerResponse((String)responseId.get(), options.getModel(), response);
            ChatModelResponseContext responseContext = new ChatModelResponseContext(modelListenerResponse, requestContext.request(), requestContext.attributes());
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(responseContext);
                }
                catch (Exception e) {
                    logger.warn("Exception while calling model listener", (Throwable)e);
                }
            });
            handler.onComplete(response);
        }
        catch (Exception exception) {
            ChatModelErrorContext errorContext = new ChatModelErrorContext((Throwable)exception, requestContext.request(), null, requestContext.attributes());
            this.listeners.forEach(listener -> {
                try {
                    listener.onError(errorContext);
                }
                catch (Exception e2) {
                    logger.warn("Exception while calling model listener", (Throwable)e2);
                }
            });
            handler.onError((Throwable)exception);
        }
    }

    private static void handle(ChatCompletions chatCompletions, StreamingResponseHandler<AiMessage> handler) {
        List choices = chatCompletions.getChoices();
        if (choices == null || choices.isEmpty()) {
            return;
        }
        ChatResponseMessage delta = ((ChatChoice)choices.get(0)).getDelta();
        if (delta != null && delta.getContent() != null) {
            handler.onNext(delta.getContent());
        }
    }

    public int estimateTokenCount(List<ChatMessage> messages) {
        return this.tokenizer.estimateTokenCountInMessages(messages);
    }

    public static Builder builder() {
        Iterator iterator = ServiceHelper.loadFactories(AzureOpenAiStreamingChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            AzureOpenAiStreamingChatModelBuilderFactory factory = (AzureOpenAiStreamingChatModelBuilderFactory)iterator.next();
            return (Builder)factory.get();
        }
        return new Builder();
    }

    public static class Builder {
        private String endpoint;
        private String serviceVersion;
        private String apiKey;
        private KeyCredential keyCredential;
        private TokenCredential tokenCredential;
        private String deploymentName;
        private Tokenizer tokenizer;
        private Integer maxTokens;
        private Double temperature;
        private Double topP;
        private Map<String, Integer> logitBias;
        private String user;
        private List<String> stop;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Duration timeout;
        private List<AzureChatExtensionConfiguration> dataSources;
        private AzureChatEnhancementConfiguration enhancements;
        private Long seed;
        private ChatCompletionsResponseFormat chatCompletionsResponseFormat;
        private ResponseFormat responseFormat;
        private Boolean strictJsonSchema;
        private Integer maxRetries;
        private ProxyOptions proxyOptions;
        private boolean logRequestsAndResponses;
        private OpenAIClient openAIClient;
        private OpenAIAsyncClient openAIAsyncClient;
        private boolean useAsyncClient = true;
        private String userAgentSuffix;
        private List<ChatModelListener> listeners;
        private Map<String, String> customHeaders;
        private Set<Capability> capabilities;

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder serviceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder nonAzureApiKey(String nonAzureApiKey) {
            this.keyCredential = new KeyCredential(nonAzureApiKey);
            this.endpoint = "https://api.openai.com/v1";
            return this;
        }

        public Builder tokenCredential(TokenCredential tokenCredential) {
            this.tokenCredential = tokenCredential;
            return this;
        }

        public Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public Builder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder dataSources(List<AzureChatExtensionConfiguration> dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public Builder enhancements(AzureChatEnhancementConfiguration enhancements) {
            this.enhancements = enhancements;
            return this;
        }

        public Builder seed(Long seed) {
            this.seed = seed;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder responseFormat(ChatCompletionsResponseFormat chatCompletionsResponseFormat) {
            this.chatCompletionsResponseFormat = chatCompletionsResponseFormat;
            return this;
        }

        public Builder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder strictJsonSchema(Boolean strictJsonSchema) {
            this.strictJsonSchema = strictJsonSchema;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder proxyOptions(ProxyOptions proxyOptions) {
            this.proxyOptions = proxyOptions;
            return this;
        }

        public Builder logRequestsAndResponses(boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder useAsyncClient(boolean useAsyncClient) {
            this.useAsyncClient = useAsyncClient;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder openAIClient(OpenAIClient openAIClient) {
            this.openAIClient = openAIClient;
            return this;
        }

        public Builder openAIAsyncClient(OpenAIAsyncClient openAIAsyncClient) {
            this.openAIAsyncClient = openAIAsyncClient;
            return this;
        }

        public Builder userAgentSuffix(String userAgentSuffix) {
            this.userAgentSuffix = userAgentSuffix;
            return this;
        }

        public Builder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public Builder supportedCapabilities(Set<Capability> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public AzureOpenAiStreamingChatModel build() {
            if (this.openAIClient == null) {
                if (this.tokenCredential != null) {
                    return new AzureOpenAiStreamingChatModel(this.endpoint, this.serviceVersion, this.tokenCredential, this.deploymentName, this.tokenizer, this.maxTokens, this.temperature, this.topP, this.logitBias, this.user, this.stop, this.presencePenalty, this.frequencyPenalty, this.dataSources, this.enhancements, this.seed, this.chatCompletionsResponseFormat, this.responseFormat, this.strictJsonSchema, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses, this.useAsyncClient, this.listeners, this.userAgentSuffix, this.customHeaders, this.capabilities);
                }
                if (this.keyCredential != null) {
                    return new AzureOpenAiStreamingChatModel(this.endpoint, this.serviceVersion, this.keyCredential, this.deploymentName, this.tokenizer, this.maxTokens, this.temperature, this.topP, this.logitBias, this.user, this.stop, this.presencePenalty, this.frequencyPenalty, this.dataSources, this.enhancements, this.seed, this.chatCompletionsResponseFormat, this.responseFormat, this.strictJsonSchema, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses, this.useAsyncClient, this.listeners, this.userAgentSuffix, this.customHeaders, this.capabilities);
                }
                return new AzureOpenAiStreamingChatModel(this.endpoint, this.serviceVersion, this.apiKey, this.deploymentName, this.tokenizer, this.maxTokens, this.temperature, this.topP, this.logitBias, this.user, this.stop, this.presencePenalty, this.frequencyPenalty, this.dataSources, this.enhancements, this.seed, this.chatCompletionsResponseFormat, this.responseFormat, this.strictJsonSchema, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses, this.useAsyncClient, this.listeners, this.userAgentSuffix, this.customHeaders, this.capabilities);
            }
            return new AzureOpenAiStreamingChatModel(this.openAIClient, this.openAIAsyncClient, this.deploymentName, this.tokenizer, this.maxTokens, this.temperature, this.topP, this.logitBias, this.user, this.stop, this.presencePenalty, this.frequencyPenalty, this.dataSources, this.enhancements, this.seed, this.chatCompletionsResponseFormat, this.responseFormat, this.strictJsonSchema, this.listeners, this.capabilities);
        }
    }
}

