/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.BulkIndexByScrollFailure;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.bulk.DeleteOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import co.elastic.clients.util.ObjectBuilder;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.elasticsearch.Document;
import dev.langchain4j.store.embedding.elasticsearch.ElasticsearchConfiguration;
import dev.langchain4j.store.embedding.elasticsearch.ElasticsearchConfigurationKnn;
import dev.langchain4j.store.embedding.elasticsearch.ElasticsearchMetadataFilterMapper;
import dev.langchain4j.store.embedding.elasticsearch.ElasticsearchRequestFailedException;
import dev.langchain4j.store.embedding.filter.Filter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchEmbeddingStore
implements EmbeddingStore<TextSegment> {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchEmbeddingStore.class);
    private final ElasticsearchConfiguration configuration;
    private final ElasticsearchClient client;
    private final String indexName;

    @Deprecated(forRemoval=true)
    public ElasticsearchEmbeddingStore(ElasticsearchConfiguration configuration, String serverUrl, String apiKey, String userName, String password, String indexName, Integer dimension) {
        this(configuration, serverUrl, apiKey, userName, password, indexName);
        log.warn("Setting the dimension is deprecated.");
    }

    @Deprecated(forRemoval=true)
    public ElasticsearchEmbeddingStore(ElasticsearchConfiguration configuration, String serverUrl, String apiKey, String userName, String password, String indexName) {
        this.configuration = configuration;
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)((String)ValidationUtils.ensureNotNull((Object)serverUrl, (String)"serverUrl")))});
        if (!Utils.isNullOrBlank((String)userName)) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
            restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticsearchEmbeddingStore.lambda$new$0((CredentialsProvider)provider, arg_0));
        }
        if (!Utils.isNullOrBlank((String)apiKey)) {
            restClientBuilder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", "Apikey " + apiKey)});
        }
        RestClientTransport transport = new RestClientTransport(restClientBuilder.build(), (JsonpMapper)new JacksonJsonpMapper());
        this.client = new ElasticsearchClient((ElasticsearchTransport)transport);
        this.indexName = (String)ValidationUtils.ensureNotNull((Object)indexName, (String)"indexName");
    }

    public ElasticsearchEmbeddingStore(ElasticsearchConfiguration configuration, RestClient restClient, String indexName) {
        JacksonJsonpMapper mapper = new JacksonJsonpMapper();
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)mapper);
        this.configuration = configuration;
        this.client = new ElasticsearchClient((ElasticsearchTransport)transport);
        this.indexName = (String)ValidationUtils.ensureNotNull((Object)indexName, (String)"indexName");
    }

    public static Builder builder() {
        return new Builder();
    }

    public String add(Embedding embedding) {
        String id = Utils.randomUUID();
        this.add(id, embedding);
        return id;
    }

    public void add(String id, Embedding embedding) {
        this.addInternal(id, embedding, null);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        String id = Utils.randomUUID();
        this.addInternal(id, embedding, textSegment);
        return id;
    }

    public List<String> addAll(List<Embedding> embeddings) {
        List<String> ids = embeddings.stream().map(ignored -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, null);
        return ids;
    }

    public List<String> addAll(List<Embedding> embeddings, List<TextSegment> embedded) {
        List<String> ids = embeddings.stream().map(ignored -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, embedded);
        return ids;
    }

    public EmbeddingSearchResult<TextSegment> search(EmbeddingSearchRequest embeddingSearchRequest) {
        log.debug("findRelevant([...{}...], {}, {})", new Object[]{embeddingSearchRequest.queryEmbedding().vector().length, embeddingSearchRequest.maxResults(), embeddingSearchRequest.minScore()});
        try {
            SearchResponse<Document> response = this.configuration.internalSearch(this.client, this.indexName, embeddingSearchRequest);
            log.trace("found [{}] results", response);
            List<EmbeddingMatch<TextSegment>> results = this.toMatches(response);
            results.forEach(em -> log.debug("doc [{}] scores [{}]", (Object)em.embeddingId(), (Object)em.score()));
            return new EmbeddingSearchResult(results);
        }
        catch (ElasticsearchException | IOException e) {
            throw new ElasticsearchRequestFailedException(e);
        }
    }

    public void removeAll(Collection<String> ids) {
        ValidationUtils.ensureNotEmpty(ids, (String)"ids");
        this.removeByIds(ids);
    }

    public void removeAll(Filter filter) {
        ValidationUtils.ensureNotNull((Object)filter, (String)"filter");
        Query query = ElasticsearchMetadataFilterMapper.map(filter);
        this.removeByQuery(query);
    }

    public void removeAll() {
        try {
            this.client.indices().delete(dir -> dir.index(this.indexName, new String[0]));
        }
        catch (ElasticsearchException e) {
            if (e.status() == 404) {
                log.debug("The index [{}] does not exist.", (Object)this.indexName);
            }
            throw new ElasticsearchRequestFailedException(e);
        }
        catch (IOException e) {
            throw new ElasticsearchRequestFailedException(e);
        }
    }

    private void addInternal(String id, Embedding embedding, TextSegment embedded) {
        this.addAllInternal(Collections.singletonList(id), Collections.singletonList(embedding), embedded == null ? null : Collections.singletonList(embedded));
    }

    private void addAllInternal(List<String> ids, List<Embedding> embeddings, List<TextSegment> embedded) {
        if (Utils.isNullOrEmpty(ids) || Utils.isNullOrEmpty(embeddings)) {
            log.info("[do not add empty embeddings to elasticsearch]");
            return;
        }
        ValidationUtils.ensureTrue((ids.size() == embeddings.size() ? 1 : 0) != 0, (String)"ids size is not equal to embeddings size");
        ValidationUtils.ensureTrue((embedded == null || embeddings.size() == embedded.size() ? 1 : 0) != 0, (String)"embeddings size is not equal to embedded size");
        try {
            this.bulkIndex(ids, embeddings, embedded);
        }
        catch (IOException e) {
            throw new ElasticsearchRequestFailedException(e);
        }
    }

    private void bulkIndex(List<String> ids, List<Embedding> embeddings, List<TextSegment> embedded) throws IOException {
        int size = ids.size();
        log.debug("calling bulkIndex with [{}] elements", (Object)size);
        BulkRequest.Builder bulkBuilder = new BulkRequest.Builder();
        for (int i = 0; i < size; ++i) {
            int finalI = i;
            Document document = Document.builder().vector(embeddings.get(i).vector()).text(embedded == null ? null : embedded.get(i).text()).metadata(embedded == null ? null : embedded.get(i).metadata().toMap()).build();
            bulkBuilder.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(this.indexName)).id((String)ids.get(finalI))).document((Object)document)));
        }
        BulkResponse response = this.client.bulk(bulkBuilder.build());
        this.handleBulkResponseErrors(response);
    }

    private void handleBulkResponseErrors(BulkResponse response) {
        if (response.errors()) {
            for (BulkResponseItem item : response.items()) {
                this.throwIfError(item.error());
            }
        }
    }

    private void throwIfError(ErrorCause errorCause) {
        if (errorCause != null) {
            throw new ElasticsearchRequestFailedException("type: " + errorCause.type() + ", reason: " + errorCause.reason());
        }
    }

    private void removeByQuery(Query query) {
        try {
            DeleteByQueryResponse response = this.client.deleteByQuery(delete -> delete.index(this.indexName, new String[0]).query(query));
            if (!response.failures().isEmpty()) {
                for (BulkIndexByScrollFailure item : response.failures()) {
                    this.throwIfError(item.cause());
                }
            }
        }
        catch (IOException e) {
            throw new ElasticsearchRequestFailedException(e);
        }
    }

    private void removeByIds(Collection<String> ids) {
        try {
            this.bulkRemove(ids);
        }
        catch (IOException e) {
            throw new ElasticsearchRequestFailedException(e);
        }
    }

    private void bulkRemove(Collection<String> ids) throws IOException {
        BulkRequest.Builder bulkBuilder = new BulkRequest.Builder();
        for (String id : ids) {
            bulkBuilder.operations(op -> op.delete(dlt -> (ObjectBuilder)((DeleteOperation.Builder)dlt.index(this.indexName)).id(id)));
        }
        BulkResponse response = this.client.bulk(bulkBuilder.build());
        this.handleBulkResponseErrors(response);
    }

    private List<EmbeddingMatch<TextSegment>> toMatches(SearchResponse<Document> response) {
        return response.hits().hits().stream().map(hit -> Optional.ofNullable((Document)hit.source()).map(document -> new EmbeddingMatch(hit.score(), hit.id(), new Embedding(document.getVector()), document.getText() == null ? null : TextSegment.from((String)document.getText(), (Metadata)new Metadata(document.getMetadata())))).orElse(null)).collect(Collectors.toList());
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$new$0(CredentialsProvider provider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(provider);
    }

    public static class Builder {
        private String serverUrl;
        private String apiKey;
        private String userName;
        private String password;
        private RestClient restClient;
        private String indexName = "default";
        private ElasticsearchConfiguration configuration = ElasticsearchConfigurationKnn.builder().build();

        @Deprecated(forRemoval=true)
        public Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder restClient(RestClient restClient) {
            this.restClient = restClient;
            return this;
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder dimension(Integer dimension) {
            log.warn("Setting the dimension is deprecated. This value is ignored.");
            return this;
        }

        public Builder configuration(ElasticsearchConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public ElasticsearchEmbeddingStore build() {
            if (this.restClient != null) {
                return new ElasticsearchEmbeddingStore(this.configuration, this.restClient, this.indexName);
            }
            log.warn("This is deprecated. You should provide a restClient instead and call ElasticsearchEmbeddingStore(ElasticsearchConfiguration, RestClient, String)");
            return new ElasticsearchEmbeddingStore(this.configuration, this.serverUrl, this.apiKey, this.userName, this.password, this.indexName);
        }
    }
}

