/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.elasticsearch.Document;
import dev.langchain4j.store.embedding.elasticsearch.ElasticsearchConfiguration;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchConfigurationFullText
extends ElasticsearchConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchConfigurationFullText.class);

    public static Builder builder() {
        return new Builder();
    }

    @Override
    SearchResponse<Document> vectorSearch(ElasticsearchClient client, String indexName, EmbeddingSearchRequest embeddingSearchRequest) throws ElasticsearchException {
        throw new UnsupportedOperationException("Full text configuration does not support embedded search");
    }

    @Override
    SearchResponse<Document> fullTextSearch(ElasticsearchClient client, String indexName, String textQuery) throws ElasticsearchException, IOException {
        log.trace("Searching for text matches in index [{}] with query [{}].", (Object)indexName, (Object)textQuery);
        return client.search(s -> s.index(indexName, new String[0]).query(q -> q.match(m -> m.field("text").query(textQuery))), Document.class);
    }

    @Override
    SearchResponse<Document> hybridSearch(ElasticsearchClient client, String indexName, EmbeddingSearchRequest embeddingSearchRequest, String textQuery) throws ElasticsearchException {
        throw new UnsupportedOperationException("Full text configuration does not support embedded search");
    }

    public static class Builder {
        public ElasticsearchConfigurationFullText build() {
            return new ElasticsearchConfigurationFullText();
        }
    }
}

