/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.KnnRetriever;
import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.elasticsearch.Document;
import dev.langchain4j.store.embedding.elasticsearch.ElasticsearchConfiguration;
import dev.langchain4j.store.embedding.elasticsearch.ElasticsearchMetadataFilterMapper;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchConfigurationHybrid
extends ElasticsearchConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchConfigurationHybrid.class);
    private final Integer numCandidates;

    public static Builder builder() {
        return new Builder();
    }

    private ElasticsearchConfigurationHybrid(Integer numCandidates, boolean includeVectorResponse) {
        this.numCandidates = numCandidates;
        this.includeVectorResponse = includeVectorResponse;
    }

    @Override
    SearchResponse<Document> vectorSearch(ElasticsearchClient client, String indexName, EmbeddingSearchRequest embeddingSearchRequest) throws ElasticsearchException {
        throw new UnsupportedOperationException("Hybrid configuration does not support vector search");
    }

    @Override
    SearchResponse<Document> fullTextSearch(ElasticsearchClient client, String indexName, String textQuery) throws ElasticsearchException {
        throw new UnsupportedOperationException("Hybrid configuration does not support full text search");
    }

    @Override
    SearchResponse<Document> hybridSearch(ElasticsearchClient client, String indexName, EmbeddingSearchRequest embeddingSearchRequest, String textQuery) throws ElasticsearchException, IOException {
        KnnRetriever.Builder krb = new KnnRetriever.Builder().field("vector").queryVector(embeddingSearchRequest.queryEmbedding().vectorAsList());
        if (embeddingSearchRequest.filter() != null) {
            krb.filter(ElasticsearchMetadataFilterMapper.map(embeddingSearchRequest.filter()), new Query[0]);
        }
        if (this.numCandidates != null) {
            krb.numCandidates(this.numCandidates.intValue());
            krb.k(Math.min(this.numCandidates, embeddingSearchRequest.maxResults()));
        } else {
            krb.numCandidates(embeddingSearchRequest.maxResults());
            krb.k(embeddingSearchRequest.maxResults());
        }
        KnnRetriever knn = krb.build();
        MatchQuery matchQuery = new MatchQuery.Builder().field("text").query(textQuery).build();
        log.trace("Searching for embeddings in index [{}] with hybrid query [{}], [{}].", new Object[]{indexName, knn, matchQuery});
        return client.search(s -> s.source(sr -> {
            if (this.includeVectorResponse) {
                return sr.filter(f -> f.excludeVectors(Boolean.valueOf(false)));
            }
            return new SourceConfig.Builder().filter(f -> f);
        }).index(indexName, new String[0]).retriever(r -> r.rrf(rf -> rf.retrievers(List.of(Retriever.of(rt -> rt.standard(st -> st.query((QueryVariant)matchQuery))), Retriever.of(rt -> rt.knn(knn)))))).size(Integer.valueOf(embeddingSearchRequest.maxResults())).minScore(Double.valueOf(embeddingSearchRequest.minScore())), Document.class);
    }

    public static class Builder {
        private Integer numCandidates;
        private boolean includeVectorResponse = false;

        public ElasticsearchConfigurationHybrid build() {
            return new ElasticsearchConfigurationHybrid(this.numCandidates, this.includeVectorResponse);
        }

        public Builder numCandidates(Integer numCandidates) {
            this.numCandidates = numCandidates;
            return this;
        }

        public Builder includeVectorResponse(boolean includeVectorResponse) {
            this.includeVectorResponse = includeVectorResponse;
            return this;
        }
    }
}

