/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.jsonformatter;

import io.cucumber.jsonformatter.CucumberJvmJson;
import io.cucumber.jsonformatter.IdNamingVisitor;
import io.cucumber.jsonformatter.JvmElementData;
import io.cucumber.jsonformatter.SourceReferenceFormatter;
import io.cucumber.jsonformatter.TestStepData;
import io.cucumber.messages.Convertor;
import io.cucumber.messages.types.Attachment;
import io.cucumber.messages.types.AttachmentContentEncoding;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.DocString;
import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Group;
import io.cucumber.messages.types.Hook;
import io.cucumber.messages.types.HookType;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.PickleTag;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.SourceReference;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.StepDefinition;
import io.cucumber.messages.types.StepMatchArgument;
import io.cucumber.messages.types.StepMatchArgumentsList;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.Tag;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.messages.types.Timestamp;
import io.cucumber.query.Lineage;
import io.cucumber.query.LineageReducer;
import io.cucumber.query.Query;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class JsonReportWriter {
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withZone(ZoneOffset.UTC);
    private final Query query;
    private final SourceReferenceFormatter sourceReferenceFormatter = new SourceReferenceFormatter();
    private final Function<URI, String> uriFormatter;

    JsonReportWriter(Query query, Function<URI, String> uriFormatter) {
        this.query = Objects.requireNonNull(query);
        this.uriFormatter = Objects.requireNonNull(uriFormatter);
    }

    private static BinaryOperator<Map.Entry<Optional<Background>, List<TestStepFinished>>> mergeEntries() {
        return (a, b) -> {
            ((List)a.getValue()).addAll((Collection)b.getValue());
            return a;
        };
    }

    private static Predicate<Map.Entry<Optional<Background>, List<TestStepFinished>>> isTestCase() {
        return JsonReportWriter.isBackGround().negate();
    }

    private static Predicate<Map.Entry<Optional<Background>, List<TestStepFinished>>> isBackGround() {
        return entry -> ((Optional)entry.getKey()).isPresent();
    }

    private static Long formatDuration(TestStepResult result) {
        java.time.Duration duration = Convertor.toDuration((Duration)result.getDuration());
        if (result.getStatus() == TestStepResultStatus.UNDEFINED) {
            return null;
        }
        return duration.isZero() ? null : Long.valueOf(duration.toNanos());
    }

    private String formatTimeStamp(Timestamp instant) {
        return this.dateTimeFormatter.format(Convertor.toInstant((Timestamp)instant));
    }

    List<Object> createJsonReport() {
        return this.query.findAllTestCaseStarted().stream().map(this::createJvmElementData).sorted(JvmElementData.comparator).collect(Collectors.groupingBy(data -> data.pickle.getUri(), LinkedHashMap::new, Collectors.toList())).values().stream().map(this::createJvmFeature).collect(Collectors.toList());
    }

    private JvmElementData createJvmElementData(TestCaseStarted testCaseStarted) {
        Pickle pickle = (Pickle)this.query.findPickleBy(testCaseStarted).orElseThrow(() -> new IllegalStateException("No Pickle for testCaseStarted " + testCaseStarted.getId()));
        Lineage lineage = (Lineage)this.query.findLineageBy(pickle).orElseThrow(() -> new IllegalStateException("No Lineage for testCaseStarted " + testCaseStarted.getId()));
        Location location = (Location)this.query.findLocationOf(pickle).orElseThrow(() -> new IllegalStateException("No Location for testCaseStarted " + testCaseStarted.getId()));
        return new JvmElementData(testCaseStarted, lineage, pickle, location, this.createTestStepData(testCaseStarted));
    }

    private TestStepData createTestStepData(TestCaseStarted testCaseStarted) {
        List testStepsFinished = this.query.findTestStepsFinishedBy(testCaseStarted);
        ArrayList<TestStepFinished> beforeTestCase = new ArrayList<TestStepFinished>();
        ArrayList<TestStepFinished> afterTestCase = new ArrayList<TestStepFinished>();
        ArrayList<TestStepFinished> beforeTestStep = new ArrayList<TestStepFinished>();
        ArrayList<TestStepFinished> afterTestStep = new ArrayList<TestStepFinished>();
        HashMap<TestStepFinished, List<TestStepFinished>> beforeTestStepByStep = new HashMap<TestStepFinished, List<TestStepFinished>>();
        HashMap<TestStepFinished, List<TestStepFinished>> afterTestStepByStep = new HashMap<TestStepFinished, List<TestStepFinished>>();
        for (TestStepFinished testStepFinished : testStepsFinished) {
            HookType hook = this.query.findTestStepBy(testStepFinished).flatMap(arg_0 -> ((Query)this.query).findHookBy(arg_0)).flatMap(Hook::getType).orElse(null);
            if (hook == null) {
                beforeTestStepByStep.put(testStepFinished, beforeTestStep);
                beforeTestStep = new ArrayList();
                afterTestStep = new ArrayList();
                afterTestStepByStep.put(testStepFinished, afterTestStep);
                continue;
            }
            switch (hook) {
                case BEFORE_TEST_RUN: 
                case AFTER_TEST_RUN: {
                    break;
                }
                case BEFORE_TEST_CASE: {
                    beforeTestCase.add(testStepFinished);
                    break;
                }
                case AFTER_TEST_CASE: {
                    afterTestCase.add(testStepFinished);
                    break;
                }
                case BEFORE_TEST_STEP: {
                    beforeTestStep.add(testStepFinished);
                    break;
                }
                case AFTER_TEST_STEP: {
                    afterTestStep.add(testStepFinished);
                }
            }
        }
        return new TestStepData(beforeTestCase, afterTestCase, beforeTestStepByStep, afterTestStepByStep);
    }

    private CucumberJvmJson.JvmFeature createJvmFeature(List<JvmElementData> elements) {
        JvmElementData firstElement = elements.get(0);
        GherkinDocument document = firstElement.lineage.document();
        Feature feature = (Feature)firstElement.lineage.feature().orElseThrow(() -> new IllegalStateException("No Feature for testCaseStarted " + firstElement.testCaseStarted.getId()));
        return new CucumberJvmJson.JvmFeature(document.getUri().map(URI::create).map(this.uriFormatter).orElse(null), IdNamingVisitor.formatId(feature.getName()), feature.getLocation().getLine(), feature.getKeyword(), feature.getName(), feature.getDescription() != null ? feature.getDescription() : "", this.createJvmElements(elements), this.createJvmLocationTags(feature));
    }

    private List<CucumberJvmJson.JvmElement> createJvmElements(List<JvmElementData> entries) {
        return entries.stream().map(this::createJvmElement).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<CucumberJvmJson.JvmElement> createJvmElement(JvmElementData data) {
        Map<Optional<Background>, List<TestStepFinished>> stepsByBackground = this.query.findTestStepFinishedAndTestStepBy(data.testCaseStarted).stream().collect(this.groupTestStepsByBackground(data));
        Optional background = stepsByBackground.entrySet().stream().filter(JsonReportWriter.isBackGround()).reduce(JsonReportWriter.mergeEntries()).flatMap(entry -> ((Optional)entry.getKey()).map(bg -> this.createBackground(data, (Background)bg, (List)entry.getValue())));
        Optional<CucumberJvmJson.JvmElement> testCase = stepsByBackground.entrySet().stream().filter(JsonReportWriter.isTestCase()).reduce(JsonReportWriter.mergeEntries()).map(Map.Entry::getValue).map(scenarioTestStepsFinished -> this.createTestCase(data, (List<TestStepFinished>)scenarioTestStepsFinished));
        return Stream.of(background, testCase).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private CucumberJvmJson.JvmElement createTestCase(JvmElementData data, List<TestStepFinished> scenarioTestStepsFinished) {
        Scenario scenario = (Scenario)data.lineage.scenario().orElseThrow(() -> new IllegalStateException("No scenario?"));
        LineageReducer idStrategy = LineageReducer.descending(IdNamingVisitor::new);
        return new CucumberJvmJson.JvmElement(this.formatTimeStamp(data.testCaseStarted.getTimestamp()), data.location.getLine(), (String)idStrategy.reduce(data.lineage), CucumberJvmJson.JvmElementType.scenario, scenario.getKeyword(), data.pickle.getName(), scenario.getDescription(), this.createTestSteps(data, scenarioTestStepsFinished), this.createHookSteps(data.testStepData.beforeTestCaseSteps), this.createHookSteps(data.testStepData.afterTestCaseSteps), this.createJvmTags(data.pickle));
    }

    private List<CucumberJvmJson.JvmTag> createJvmTags(Pickle pickle) {
        return pickle.getTags().stream().map(this::createJvmTag).collect(Collectors.toList());
    }

    private CucumberJvmJson.JvmTag createJvmTag(PickleTag pickleTag) {
        return new CucumberJvmJson.JvmTag(pickleTag.getName());
    }

    private List<CucumberJvmJson.JvmHook> createHookSteps(List<TestStepFinished> testStepsFinished) {
        return testStepsFinished.stream().map(this::createJvmHook).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<CucumberJvmJson.JvmHook> createJvmHook(TestStepFinished testStepFinished) {
        List attachments = this.query.findAttachmentsBy(testStepFinished);
        return this.query.findTestStepBy(testStepFinished).flatMap(testStep -> this.query.findHookBy(testStep).map(hook -> new CucumberJvmJson.JvmHook(this.createJvmMatch((TestStep)testStep), this.createJvmResult(testStepFinished.getTestStepResult()), this.createEmbeddings(attachments), this.createOutput(attachments))));
    }

    private CucumberJvmJson.JvmResult createJvmResult(TestStepResult result) {
        return new CucumberJvmJson.JvmResult(JsonReportWriter.formatDuration(result), CucumberJvmJson.JvmStatus.valueOf(result.getStatus().name().toLowerCase(Locale.ROOT)), result.getException().flatMap(Exception::getStackTrace).orElse(null));
    }

    private List<CucumberJvmJson.JvmEmbedding> createEmbeddings(List<Attachment> attachments) {
        return attachments.stream().filter(attachment -> !JsonReportWriter.isTextCucumberLogPlain(attachment.getMediaType())).map(attachment -> new CucumberJvmJson.JvmEmbedding(attachment.getMediaType(), JsonReportWriter.encodeBodyAsBase64(attachment), attachment.getFileName().orElse(null))).collect(Collectors.toList());
    }

    private static String encodeBodyAsBase64(Attachment attachment) {
        AttachmentContentEncoding encoding = attachment.getContentEncoding();
        String body = attachment.getBody();
        switch (encoding) {
            case IDENTITY: {
                byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
                Base64.Encoder encoder = Base64.getEncoder();
                return encoder.encodeToString(bytes);
            }
            case BASE64: {
                return body;
            }
        }
        throw new RuntimeException("Unknown content encoding " + encoding);
    }

    private List<String> createOutput(List<Attachment> attachments) {
        return attachments.stream().filter(attachment -> JsonReportWriter.isTextCucumberLogPlain(attachment.getMediaType())).map(JsonReportWriter::encodeBodyAsPlainText).collect(Collectors.toList());
    }

    private static String encodeBodyAsPlainText(Attachment attachment) {
        AttachmentContentEncoding encoding = attachment.getContentEncoding();
        String body = attachment.getBody();
        switch (encoding) {
            case IDENTITY: {
                return body;
            }
            case BASE64: {
                Base64.Decoder decoder = Base64.getDecoder();
                return new String(decoder.decode(body), StandardCharsets.UTF_8);
            }
        }
        throw new RuntimeException("Unknown content encoding " + encoding);
    }

    private static boolean isTextCucumberLogPlain(String mediaType) {
        return mediaType.equals("text/x.cucumber.log+plain");
    }

    private List<CucumberJvmJson.JvmLocationTag> createJvmLocationTags(Feature feature) {
        return feature.getTags().stream().map(this::createJvmLocationTag).collect(Collectors.toList());
    }

    private CucumberJvmJson.JvmLocationTag createJvmLocationTag(Tag tag) {
        return new CucumberJvmJson.JvmLocationTag(tag.getName(), "Tag", new CucumberJvmJson.JvmLocation(tag.getLocation().getLine(), tag.getLocation().getColumn().orElse(0L)));
    }

    private CucumberJvmJson.JvmElement createBackground(JvmElementData data, Background background, List<TestStepFinished> backgroundTestStepsFinished) {
        return new CucumberJvmJson.JvmElement(null, background.getLocation().getLine(), null, CucumberJvmJson.JvmElementType.background, background.getKeyword(), background.getName(), background.getDescription(), this.createTestSteps(data, backgroundTestStepsFinished), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    private List<CucumberJvmJson.JvmStep> createTestSteps(JvmElementData data, List<TestStepFinished> testStepsFinished) {
        return testStepsFinished.stream().map(testStepFinished -> this.createTestStep(data, (TestStepFinished)testStepFinished)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<CucumberJvmJson.JvmStep> createTestStep(JvmElementData data, TestStepFinished testStepFinished) {
        List beforeStepHooks = data.testStepData.beforeStepStepsByStep.getOrDefault(testStepFinished, Collections.emptyList());
        List afterStepHooks = data.testStepData.afterStepStepsByStep.getOrDefault(testStepFinished, Collections.emptyList());
        List attachments = this.query.findAttachmentsBy(testStepFinished);
        return this.query.findTestStepBy(testStepFinished).flatMap(testStep -> this.query.findPickleStepBy(testStep).flatMap(pickleStep -> this.query.findStepBy(pickleStep).map(step -> new CucumberJvmJson.JvmStep(step.getKeyword(), step.getLocation().getLine(), this.createJvmMatch((TestStep)testStep), pickleStep.getText(), this.createJvmResult(testStepFinished.getTestStepResult()), this.createJvmDocString((Step)step), this.createJvmDataTableRows((Step)step), this.createHookSteps(beforeStepHooks), this.createHookSteps(afterStepHooks), this.createEmbeddings(attachments), this.createOutput(attachments)))));
    }

    private CucumberJvmJson.JvmMatch createJvmMatch(TestStep testStep) {
        return new CucumberJvmJson.JvmMatch(this.createLocation(testStep), this.createJvmArguments(testStep));
    }

    private List<CucumberJvmJson.JvmArgument> createJvmArguments(TestStep step) {
        return step.getStepMatchArgumentsLists().filter(stepMatchArgumentsLists -> stepMatchArgumentsLists.size() == 1).map(argumentsLists -> argumentsLists.stream().map(StepMatchArgumentsList::getStepMatchArguments).flatMap(Collection::stream).map(this::createJvmArgument).collect(Collectors.toList())).filter(jvmArguments -> !jvmArguments.isEmpty()).orElse(null);
    }

    private CucumberJvmJson.JvmArgument createJvmArgument(StepMatchArgument argument) {
        Group group = argument.getGroup();
        return new CucumberJvmJson.JvmArgument(group.getValue().orElse(null), group.getStart().orElse(null));
    }

    private List<CucumberJvmJson.JvmDataTableRow> createJvmDataTableRows(Step step) {
        return step.getDataTable().map(this::createJvmDataTableRows).orElse(null);
    }

    private List<CucumberJvmJson.JvmDataTableRow> createJvmDataTableRows(DataTable argument) {
        return argument.getRows().stream().map(row -> new CucumberJvmJson.JvmDataTableRow(row.getCells().stream().map(TableCell::getValue).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    private CucumberJvmJson.JvmDocString createJvmDocString(Step step) {
        return step.getDocString().map(this::createJvmDocString).orElse(null);
    }

    private CucumberJvmJson.JvmDocString createJvmDocString(DocString docString) {
        return new CucumberJvmJson.JvmDocString(docString.getLocation().getLine(), docString.getContent(), docString.getMediaType().orElse(null));
    }

    private String createLocation(TestStep step) {
        return this.findSourceReference(step).flatMap(this.sourceReferenceFormatter::format).orElse(null);
    }

    private Collector<Map.Entry<TestStepFinished, TestStep>, ?, Map<Optional<Background>, List<TestStepFinished>>> groupTestStepsByBackground(JvmElementData data) {
        List backgrounds = data.lineage.feature().map(this::findBackgroundsBy).orElseGet(Collections::emptyList);
        Function<Map.Entry, Optional> grouping = entry -> this.query.findPickleStepBy((TestStep)entry.getValue()).flatMap(pickleStep -> this.findBackgroundBy(backgrounds, (PickleStep)pickleStep));
        Function<List, List> extractKey = entries -> entries.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        return Collectors.groupingBy(grouping, LinkedHashMap::new, Collectors.collectingAndThen(Collectors.toList(), extractKey));
    }

    private List<Background> findBackgroundsBy(Feature feature) {
        return feature.getChildren().stream().map(featureChild -> {
            ArrayList backgrounds = new ArrayList();
            featureChild.getBackground().ifPresent(backgrounds::add);
            featureChild.getRule().map(Rule::getChildren).map(Collection::stream).orElseGet(Stream::empty).map(RuleChild::getBackground).filter(Optional::isPresent).map(Optional::get).forEach(backgrounds::add);
            return backgrounds;
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Optional<Background> findBackgroundBy(List<Background> backgrounds, PickleStep pickleStep) {
        return backgrounds.stream().filter(background -> background.getSteps().stream().map(Step::getId).anyMatch(step -> pickleStep.getAstNodeIds().contains(step))).findFirst();
    }

    private Optional<SourceReference> findSourceReference(TestStep step) {
        Optional<SourceReference> source = this.query.findUnambiguousStepDefinitionBy(step).map(StepDefinition::getSourceReference);
        if (source.isPresent()) {
            return source;
        }
        return this.query.findHookBy(step).map(Hook::getSourceReference);
    }
}

