/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.query;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TableRow;
import java.util.Objects;
import java.util.Optional;

public final class Lineage {
    private final GherkinDocument document;
    private final Feature feature;
    private final Rule rule;
    private final Scenario scenario;
    private final Examples examples;
    private final Integer examplesIndex;
    private final TableRow example;
    private final Integer exampleIndex;

    Lineage(GherkinDocument document) {
        this(document, null, null, null, null, null, null, null);
    }

    Lineage(Lineage parent, Feature feature) {
        this(parent.document, feature, null, null, null, null, null, null);
    }

    Lineage(Lineage parent, Rule rule) {
        this(parent.document, parent.feature, rule, null, null, null, null, null);
    }

    Lineage(Lineage parent, Scenario scenario) {
        this(parent.document, parent.feature, parent.rule, scenario, null, null, null, null);
    }

    Lineage(Lineage parent, Examples examples, int examplesIndex) {
        this(parent.document, parent.feature, parent.rule, parent.scenario, examples, examplesIndex, null, null);
    }

    Lineage(Lineage parent, TableRow example, int exampleIndex) {
        this(parent.document, parent.feature, parent.rule, parent.scenario, parent.examples, parent.examplesIndex, example, exampleIndex);
    }

    private Lineage(GherkinDocument document, Feature feature, Rule rule, Scenario scenario, Examples examples, Integer examplesIndex, TableRow example, Integer exampleIndex) {
        this.document = Objects.requireNonNull(document);
        this.feature = feature;
        this.rule = rule;
        this.scenario = scenario;
        this.examples = examples;
        this.examplesIndex = examplesIndex;
        this.example = example;
        this.exampleIndex = exampleIndex;
    }

    public GherkinDocument document() {
        return this.document;
    }

    public Optional<Feature> feature() {
        return Optional.ofNullable(this.feature);
    }

    public Optional<Rule> rule() {
        return Optional.ofNullable(this.rule);
    }

    public Optional<Scenario> scenario() {
        return Optional.ofNullable(this.scenario);
    }

    public Optional<Examples> examples() {
        return Optional.ofNullable(this.examples);
    }

    public Optional<TableRow> example() {
        return Optional.ofNullable(this.example);
    }

    public Optional<Integer> examplesIndex() {
        return Optional.ofNullable(this.examplesIndex);
    }

    public Optional<Integer> exampleIndex() {
        return Optional.ofNullable(this.exampleIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lineage that = (Lineage)o;
        return this.document.equals((Object)that.document) && this.feature.equals((Object)that.feature) && Objects.equals(this.rule, that.rule) && this.scenario.equals((Object)that.scenario) && Objects.equals(this.examples, that.examples) && Objects.equals(this.example, that.example) && Objects.equals(this.examplesIndex, that.examplesIndex) && Objects.equals(this.exampleIndex, that.exampleIndex);
    }

    public int hashCode() {
        return Objects.hash(this.document, this.feature, this.rule, this.scenario, this.examples, this.example, this.examplesIndex, this.exampleIndex);
    }
}

