/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.query;

import io.cucumber.messages.types.Attachment;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Hook;
import io.cucumber.messages.types.Meta;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.StepDefinition;
import io.cucumber.messages.types.Suggestion;
import io.cucumber.messages.types.TestCase;
import io.cucumber.messages.types.TestCaseFinished;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestRunHookFinished;
import io.cucumber.messages.types.TestRunHookStarted;
import io.cucumber.messages.types.TestRunStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepStarted;
import io.cucumber.messages.types.UndefinedParameterType;
import io.cucumber.query.Lineage;
import io.cucumber.query.Lineages;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public final class Repository {
    private final Set<RepositoryFeature> features;
    final Map<String, TestCaseStarted> testCaseStartedById = new LinkedHashMap<String, TestCaseStarted>();
    final Map<String, TestCaseFinished> testCaseFinishedByTestCaseStartedId = new LinkedHashMap<String, TestCaseFinished>();
    final Map<String, List<TestStepFinished>> testStepsFinishedByTestCaseStartedId = new LinkedHashMap<String, List<TestStepFinished>>();
    final Map<String, List<TestStepStarted>> testStepsStartedByTestCaseStartedId = new LinkedHashMap<String, List<TestStepStarted>>();
    final Map<String, TestRunHookStarted> testRunHookStartedById = new LinkedHashMap<String, TestRunHookStarted>();
    final Map<String, TestRunHookFinished> testRunHookFinishedByTestRunHookStartedId = new LinkedHashMap<String, TestRunHookFinished>();
    final Map<String, Pickle> pickleById = new LinkedHashMap<String, Pickle>();
    final Map<String, TestCase> testCaseById = new LinkedHashMap<String, TestCase>();
    final Map<String, Step> stepById = new LinkedHashMap<String, Step>();
    final Map<String, TestStep> testStepById = new LinkedHashMap<String, TestStep>();
    final Map<String, PickleStep> pickleStepById = new LinkedHashMap<String, PickleStep>();
    final Map<String, Hook> hookById = new LinkedHashMap<String, Hook>();
    final Map<String, List<Attachment>> attachmentsByTestCaseStartedId = new LinkedHashMap<String, List<Attachment>>();
    final Map<String, List<Attachment>> attachmentsByTestRunHookStartedId = new LinkedHashMap<String, List<Attachment>>();
    final Map<Object, Lineage> lineageById = new HashMap<Object, Lineage>();
    final Map<String, StepDefinition> stepDefinitionById = new LinkedHashMap<String, StepDefinition>();
    final Map<String, List<Suggestion>> suggestionsByPickleStepId = new LinkedHashMap<String, List<Suggestion>>();
    final List<UndefinedParameterType> undefinedParameterTypes = new ArrayList<UndefinedParameterType>();
    Meta meta;
    TestRunStarted testRunStarted;
    TestRunFinished testRunFinished;

    private Repository(Set<RepositoryFeature> features) {
        this.features = features;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void update(Envelope envelope) {
        envelope.getMeta().ifPresent(this::updateMeta);
        envelope.getTestRunStarted().ifPresent(this::updateTestRunStarted);
        envelope.getTestRunFinished().ifPresent(this::updateTestRunFinished);
        envelope.getTestRunHookStarted().ifPresent(this::updateTestRunHookStarted);
        envelope.getTestRunHookFinished().ifPresent(this::updateTestRunHookFinished);
        envelope.getTestCaseStarted().ifPresent(this::updateTestCaseStarted);
        envelope.getTestCaseFinished().ifPresent(this::updateTestCaseFinished);
        envelope.getTestStepStarted().ifPresent(this::updateTestStepStarted);
        envelope.getTestStepFinished().ifPresent(this::updateTestStepFinished);
        envelope.getPickle().ifPresent(this::updatePickle);
        envelope.getTestCase().ifPresent(this::updateTestCase);
        if (this.features.contains((Object)RepositoryFeature.INCLUDE_GHERKIN_DOCUMENTS)) {
            envelope.getGherkinDocument().ifPresent(this::updateGherkinDocument);
        }
        if (this.features.contains((Object)RepositoryFeature.INCLUDE_STEP_DEFINITIONS)) {
            envelope.getStepDefinition().ifPresent(this::updateStepDefinition);
        }
        if (this.features.contains((Object)RepositoryFeature.INCLUDE_HOOKS)) {
            envelope.getHook().ifPresent(this::updateHook);
        }
        if (this.features.contains((Object)RepositoryFeature.INCLUDE_ATTACHMENTS)) {
            envelope.getAttachment().ifPresent(this::updateAttachment);
        }
        if (this.features.contains((Object)RepositoryFeature.INCLUDE_SUGGESTIONS)) {
            envelope.getSuggestion().ifPresent(this::updateSuggestions);
        }
        if (this.features.contains((Object)RepositoryFeature.INCLUDE_UNDEFINED_PARAMETER_TYPES)) {
            envelope.getUndefinedParameterType().ifPresent(this::updateUndefinedParameterType);
        }
    }

    private void updateAttachment(Attachment attachment) {
        attachment.getTestCaseStartedId().ifPresent(testCaseStartedId -> this.attachmentsByTestCaseStartedId.compute((String)testCaseStartedId, this.updateList(attachment)));
        attachment.getTestRunHookStartedId().ifPresent(testRunHookStartedId -> this.attachmentsByTestRunHookStartedId.compute((String)testRunHookStartedId, this.updateList(attachment)));
    }

    private void updateHook(Hook hook) {
        this.hookById.put(hook.getId(), hook);
    }

    private void updateTestCaseStarted(TestCaseStarted testCaseStarted) {
        this.testCaseStartedById.put(testCaseStarted.getId(), testCaseStarted);
    }

    private void updateTestCase(TestCase event) {
        this.testCaseById.put(event.getId(), event);
        event.getTestSteps().forEach(testStep -> this.testStepById.put(testStep.getId(), (TestStep)testStep));
    }

    private void updatePickle(Pickle event) {
        this.pickleById.put(event.getId(), event);
        event.getSteps().forEach(pickleStep -> this.pickleStepById.put(pickleStep.getId(), (PickleStep)pickleStep));
    }

    private void updateGherkinDocument(GherkinDocument document) {
        this.lineageById.putAll(Lineages.of(document));
        document.getFeature().ifPresent(this::updateFeature);
    }

    private void updateFeature(Feature feature) {
        feature.getChildren().forEach(featureChild -> {
            featureChild.getBackground().ifPresent(background -> this.updateSteps(background.getSteps()));
            featureChild.getScenario().ifPresent(this::updateScenario);
            featureChild.getRule().ifPresent(rule -> rule.getChildren().forEach(ruleChild -> {
                ruleChild.getBackground().ifPresent(background -> this.updateSteps(background.getSteps()));
                ruleChild.getScenario().ifPresent(this::updateScenario);
            }));
        });
    }

    private void updateTestStepStarted(TestStepStarted event) {
        this.testStepsStartedByTestCaseStartedId.compute(event.getTestCaseStartedId(), this.updateList(event));
    }

    private void updateTestStepFinished(TestStepFinished event) {
        this.testStepsFinishedByTestCaseStartedId.compute(event.getTestCaseStartedId(), this.updateList(event));
    }

    private void updateTestCaseFinished(TestCaseFinished event) {
        this.testCaseFinishedByTestCaseStartedId.put(event.getTestCaseStartedId(), event);
    }

    private void updateTestRunFinished(TestRunFinished event) {
        this.testRunFinished = event;
    }

    private void updateTestRunStarted(TestRunStarted event) {
        this.testRunStarted = event;
    }

    private void updateTestRunHookStarted(TestRunHookStarted event) {
        this.testRunHookStartedById.put(event.getId(), event);
    }

    private void updateTestRunHookFinished(TestRunHookFinished event) {
        this.testRunHookFinishedByTestRunHookStartedId.put(event.getTestRunHookStartedId(), event);
    }

    private void updateScenario(Scenario scenario) {
        this.updateSteps(scenario.getSteps());
    }

    private void updateStepDefinition(StepDefinition event) {
        this.stepDefinitionById.put(event.getId(), event);
    }

    private void updateSteps(List<Step> steps) {
        steps.forEach(step -> this.stepById.put(step.getId(), (Step)step));
    }

    private void updateSuggestions(Suggestion event) {
        this.suggestionsByPickleStepId.compute(event.getPickleStepId(), this.updateList(event));
    }

    private void updateMeta(Meta event) {
        this.meta = event;
    }

    private void updateUndefinedParameterType(UndefinedParameterType event) {
        this.undefinedParameterTypes.add(event);
    }

    private <K, E> BiFunction<K, List<E>, List<E>> updateList(E element) {
        return (key, existing) -> {
            if (existing != null) {
                existing.add(element);
                return existing;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(element);
            return list;
        };
    }

    public static class Builder {
        private final EnumSet<RepositoryFeature> features = EnumSet.noneOf(RepositoryFeature.class);

        private Builder() {
        }

        public Builder feature(RepositoryFeature feature, boolean enabled) {
            if (enabled) {
                this.features.add(feature);
            } else {
                this.features.remove((Object)feature);
            }
            return this;
        }

        public Repository build() {
            return new Repository(EnumSet.copyOf(this.features));
        }
    }

    public static enum RepositoryFeature {
        INCLUDE_ATTACHMENTS,
        INCLUDE_GHERKIN_DOCUMENTS,
        INCLUDE_HOOKS,
        INCLUDE_STEP_DEFINITIONS,
        INCLUDE_SUGGESTIONS,
        INCLUDE_UNDEFINED_PARAMETER_TYPES;

    }
}

