/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.usageformatter;

import io.cucumber.messages.Convertor;
import io.cucumber.messages.types.StepDefinition;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.query.Query;
import io.cucumber.usageformatter.Durations;
import io.cucumber.usageformatter.UsageReport;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

final class UsageReportBuilder {
    private final Query query;

    UsageReportBuilder(Query query) {
        this.query = Objects.requireNonNull(query);
    }

    UsageReport build() {
        Map testStepsFinishedByStepDefinition = this.query.findAllTestStepFinished().stream().collect(Collectors.groupingBy(this.findUnambiguousStepDefinitionBy(), LinkedHashMap::new, Collectors.mapping(this.createStepUsage(), Collectors.toList())));
        this.query.findAllStepDefinitions().stream().map(Optional::of).forEach(stepDefinition -> testStepsFinishedByStepDefinition.computeIfAbsent(stepDefinition, sd -> new ArrayList()));
        List<UsageReport.StepDefinitionUsage> stepDefinitionUsages = testStepsFinishedByStepDefinition.entrySet().stream().filter(entry -> ((Optional)entry.getKey()).isPresent()).map(entry -> this.createStepDefinitionUsage((StepDefinition)((Optional)entry.getKey()).get(), UsageReportBuilder.flatten((List)entry.getValue()))).collect(Collectors.toList());
        return new UsageReport(stepDefinitionUsages);
    }

    private UsageReport.StepDefinitionUsage createStepDefinitionUsage(StepDefinition stepDefinition, List<UsageReport.StepUsage> matches) {
        return new UsageReport.StepDefinitionUsage(stepDefinition.getPattern(), stepDefinition.getSourceReference(), this.createStatistics(matches), matches);
    }

    private UsageReport.Statistics createStatistics(List<UsageReport.StepUsage> stepUsages) {
        List<Duration> durations = stepUsages.stream().map(UsageReport.StepUsage::getDuration).map(Convertor::toDuration).collect(Collectors.toList());
        return Durations.createStatistics(durations);
    }

    private Function<TestStepFinished, Optional<UsageReport.StepUsage>> createStepUsage() {
        return testStepFinished -> this.query.findTestStepBy(testStepFinished).flatMap(arg_0 -> ((Query)this.query).findPickleStepBy(arg_0)).flatMap(pickleStep -> this.query.findPickleBy(testStepFinished).map(pickle -> new UsageReport.StepUsage(pickleStep.getText(), testStepFinished.getTestStepResult().getDuration(), pickle.getUri(), this.query.findLocationOf(pickle).orElse(null))));
    }

    private Function<TestStepFinished, Optional<StepDefinition>> findUnambiguousStepDefinitionBy() {
        return testStepFinished -> this.query.findTestStepBy(testStepFinished).flatMap(arg_0 -> ((Query)this.query).findUnambiguousStepDefinitionBy(arg_0));
    }

    private static List<UsageReport.StepUsage> flatten(List<Optional<UsageReport.StepUsage>> value) {
        return value.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

