/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.common;

import io.micrometer.common.KeyValue;
import io.micrometer.common.lang.Nullable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class KeyValues
implements Iterable<KeyValue> {
    private static final KeyValues EMPTY = new KeyValues(new KeyValue[0], 0);
    private final KeyValue[] sortedSet;
    private final int length;

    private KeyValues(KeyValue[] sortedSet, int length) {
        this.sortedSet = sortedSet;
        this.length = length;
    }

    private static boolean isSortedSet(KeyValue[] keyValues, int length) {
        if (length > keyValues.length) {
            return false;
        }
        for (int i = 0; i < length - 1; ++i) {
            int cmp = keyValues[i].compareTo(keyValues[i + 1]);
            if (cmp < 0) continue;
            return false;
        }
        return true;
    }

    private static KeyValues make(KeyValue[] keyValues) {
        int len = keyValues.length;
        if (!KeyValues.isSortedSet(keyValues, len)) {
            Arrays.sort(keyValues);
            len = KeyValues.dedup(keyValues);
        }
        return new KeyValues(keyValues, len);
    }

    private static int dedup(KeyValue[] keyValues) {
        int n = keyValues.length;
        if (n == 0 || n == 1) {
            return n;
        }
        int j = 0;
        for (int i = 0; i < n - 1; ++i) {
            if (keyValues[i].getKey().equals(keyValues[i + 1].getKey())) continue;
            keyValues[j++] = keyValues[i];
        }
        keyValues[j++] = keyValues[n - 1];
        return j;
    }

    private KeyValues merged(KeyValues other) {
        if (other.length == 0) {
            return this;
        }
        if (Objects.equals(this, other)) {
            return this;
        }
        KeyValue[] sortedSet = new KeyValue[this.length + other.length];
        int sortedIdx = 0;
        int thisIdx = 0;
        int otherIdx = 0;
        while (thisIdx < this.length && otherIdx < other.length) {
            int cmp = this.sortedSet[thisIdx].compareTo(other.sortedSet[otherIdx]);
            if (cmp > 0) {
                sortedSet[sortedIdx] = other.sortedSet[otherIdx];
                ++otherIdx;
            } else if (cmp < 0) {
                sortedSet[sortedIdx] = this.sortedSet[thisIdx];
                ++thisIdx;
            } else {
                sortedSet[sortedIdx] = other.sortedSet[otherIdx];
                ++thisIdx;
                ++otherIdx;
            }
            ++sortedIdx;
        }
        int thisRemaining = this.length - thisIdx;
        if (thisRemaining > 0) {
            System.arraycopy(this.sortedSet, thisIdx, sortedSet, sortedIdx, thisRemaining);
            sortedIdx += thisRemaining;
        }
        int otherRemaining = other.length - otherIdx;
        if (otherIdx < other.sortedSet.length) {
            System.arraycopy(other.sortedSet, otherIdx, sortedSet, sortedIdx, otherRemaining);
            sortedIdx += otherRemaining;
        }
        return new KeyValues(sortedSet, sortedIdx);
    }

    public KeyValues and(String key, String value) {
        return this.and(KeyValue.of(key, value));
    }

    public KeyValues and(String ... keyValues) {
        if (KeyValues.blankVarargs(keyValues)) {
            return this;
        }
        return this.and(KeyValues.of(keyValues));
    }

    public KeyValues and(KeyValue ... keyValues) {
        if (KeyValues.blankVarargs(keyValues)) {
            return this;
        }
        return this.and(KeyValues.make(keyValues));
    }

    public <E> KeyValues and(@Nullable Iterable<E> elements, Function<E, String> keyExtractor, Function<E, String> valueExtractor) {
        if (elements == null || !elements.iterator().hasNext()) {
            return this;
        }
        Iterable keyValues = () -> StreamSupport.stream(elements.spliterator(), false).map(element -> KeyValue.of(element, keyExtractor, valueExtractor)).iterator();
        return this.and(keyValues);
    }

    public KeyValues and(@Nullable Iterable<? extends KeyValue> keyValues) {
        if (keyValues == null || keyValues == EMPTY || !keyValues.iterator().hasNext()) {
            return this;
        }
        if (this.length == 0) {
            return KeyValues.of(keyValues);
        }
        return this.merged(KeyValues.of(keyValues));
    }

    @Override
    public Iterator<KeyValue> iterator() {
        return new ArrayIterator();
    }

    @Override
    public Spliterator<KeyValue> spliterator() {
        return Spliterators.spliterator(this.sortedSet, 0, this.length, 1301);
    }

    public Stream<KeyValue> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.length; ++i) {
            result = 31 * result + this.sortedSet[i].hashCode();
        }
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.keyValuesEqual((KeyValues)obj);
    }

    private boolean keyValuesEqual(KeyValues obj) {
        if (this.sortedSet == obj.sortedSet) {
            return true;
        }
        if (this.length != obj.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.sortedSet[i].equals(obj.sortedSet[i])) continue;
            return false;
        }
        return true;
    }

    public static KeyValues concat(@Nullable Iterable<? extends KeyValue> keyValues, @Nullable Iterable<? extends KeyValue> otherKeyValues) {
        return KeyValues.of(keyValues).and(otherKeyValues);
    }

    public static KeyValues concat(@Nullable Iterable<? extends KeyValue> keyValues, String ... otherKeyValues) {
        return KeyValues.of(keyValues).and(otherKeyValues);
    }

    public static <E> KeyValues of(@Nullable Iterable<E> elements, Function<E, String> keyExtractor, Function<E, String> valueExtractor) {
        return KeyValues.empty().and(elements, keyExtractor, valueExtractor);
    }

    public static KeyValues of(@Nullable Iterable<? extends KeyValue> keyValues) {
        if (keyValues == null || keyValues == EMPTY || !keyValues.iterator().hasNext()) {
            return KeyValues.empty();
        }
        if (keyValues instanceof KeyValues) {
            return (KeyValues)keyValues;
        }
        if (keyValues instanceof Collection) {
            Collection keyValuesCollection = (Collection)keyValues;
            return KeyValues.make(keyValuesCollection.toArray(new KeyValue[0]));
        }
        return KeyValues.make((KeyValue[])StreamSupport.stream(keyValues.spliterator(), false).toArray(KeyValue[]::new));
    }

    public static KeyValues of(String key, String value) {
        return new KeyValues(new KeyValue[]{KeyValue.of(key, value)}, 1);
    }

    public static KeyValues of(String ... keyValues) {
        if (KeyValues.blankVarargs(keyValues)) {
            return KeyValues.empty();
        }
        if (keyValues.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
        }
        KeyValue[] keyValueArray = new KeyValue[keyValues.length / 2];
        for (int i = 0; i < keyValues.length; i += 2) {
            keyValueArray[i / 2] = KeyValue.of(keyValues[i], keyValues[i + 1]);
        }
        return KeyValues.make(keyValueArray);
    }

    private static boolean blankVarargs(@Nullable Object[] args) {
        return args == null || args.length == 0 || args.length == 1 && args[0] == null;
    }

    public static KeyValues of(KeyValue ... keyValues) {
        return KeyValues.empty().and(keyValues);
    }

    public static KeyValues empty() {
        return EMPTY;
    }

    public String toString() {
        return this.stream().map((Function<KeyValue, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/micrometer/common/KeyValue;)Ljava/lang/String;)()).collect(Collectors.joining(",", "[", "]"));
    }

    private class ArrayIterator
    implements Iterator<KeyValue> {
        private int currentIndex = 0;

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < KeyValues.this.length;
        }

        @Override
        public KeyValue next() {
            return KeyValues.this.sortedSet[this.currentIndex++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove items from key values");
        }
    }
}

