/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health40.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.microprofile.health.internal.AppTracker;
import com.ibm.ws.microprofile.health.services.HealthCheckBeanCallException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.health30.internal.HealthCheck30HttpResponseBuilder;
import io.openliberty.microprofile.health40.internal.FileHealthCheckBuilder;
import io.openliberty.microprofile.health40.internal.HealthCheck40Service;
import io.openliberty.microprofile.health40.internal.HealthFileUtils;
import io.openliberty.microprofile.health40.services.HealthCheck40Executor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={HealthCheck40Service.class}, property={"service.vendor=IBM"}, configurationPid={"io.openliberty.microprofile.health"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true)
public class HealthCheck40ServiceImpl
implements HealthCheck40Service {
    private static final TraceComponent tc = Tr.register(HealthCheck40ServiceImpl.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
    private AppTracker appTracker;
    private HealthCheck40Executor hcExecutor;
    private Timer startedTimer;
    private Timer liveTimer;
    private Timer readyTimer;
    private volatile int fileUpdateIntevalMilliseconds = -1;
    protected volatile boolean isCheckPointFinished = false;
    protected boolean isValidSystemForFileHealthCheck = false;
    final AtomicBoolean readinessWarningAlreadyShown = new AtomicBoolean(false);
    final AtomicBoolean startupWarningAlreadyShown = new AtomicBoolean(false);
    AtomicInteger unstartedAppsCounter = new AtomicInteger(0);
    static HealthCheckResponse.Status DEFAULT_READINESS_STATUS;
    static HealthCheckResponse.Status DEFAULT_STARTUP_STATUS;
    static final long serialVersionUID = 6674764489124440026L;

    private boolean isFileHealthCheckingEnabled() {
        return this.fileUpdateIntevalMilliseconds > 0;
    }

    @Reference(service=AppTracker.class)
    protected void setAppTracker(AppTracker service) {
        this.appTracker = service;
        this.appTracker.setHealthCheckService(this);
    }

    protected void unsetAppTracker(AppTracker service) {
        if (this.appTracker == service) {
            this.appTracker = null;
            this.stopTimers();
        }
    }

    private synchronized void stopTimers() {
        if (ProductInfo.getBetaEdition()) {
            if (this.startedTimer != null) {
                this.startedTimer.cancel();
                this.startedTimer = null;
            }
            if (this.liveTimer != null) {
                this.liveTimer.cancel();
                this.liveTimer = null;
            }
            if (this.readyTimer != null) {
                this.readyTimer.cancel();
                this.readyTimer = null;
            }
        }
    }

    @Reference(service=HealthCheck40Executor.class)
    protected void setHealthExecutor(HealthCheck40Executor service) {
        this.hcExecutor = service;
    }

    protected void unsetHealthExecutor(HealthCheck40Executor service) {
        if (this.hcExecutor == service) {
            this.hcExecutor = null;
            this.stopTimers();
        }
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        if (ProductInfo.getBetaEdition()) {
            String serverFileUpdateIntervalConfig = (String)properties.get("fileUpdateInterval");
            if (serverFileUpdateIntervalConfig != null) {
                this.processUpdateIntervalConfig(serverFileUpdateIntervalConfig);
            } else {
                this.processUpdateIntervalConfig(System.getenv("MP_HEALTH_FILE_UPDATE_INTERVAL"));
            }
            if (this.isFileHealthCheckingEnabled()) {
                Set<String> apps;
                try {
                    this.isValidSystemForFileHealthCheck = HealthFileUtils.isValidSystem();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Is system valid for File health check: " + this.isValidSystemForFileHealthCheck), (Object[])new Object[0]);
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"io.openliberty.microprofile.health40.internal.HealthCheck40ServiceImpl", (String)"175", (Object)this, (Object[])new Object[]{cc, properties});
                }
                if (this.isValidSystemForFileHealthCheck && (apps = this.validateApplicationSet()).size() == 0) {
                    this.startFileHealthCheckProcesses();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"HealthCheckServiceImpl is activated", (Object[])new Object[0]);
        }
    }

    protected void processUpdateIntervalConfig(String configValue) {
        if (configValue != null && !configValue.isEmpty()) {
            int prevConfigIntervalMilliseconds = this.fileUpdateIntevalMilliseconds;
            if ((configValue = configValue.trim()).matches("^\\d+(ms|s)?$")) {
                this.fileUpdateIntevalMilliseconds = configValue.endsWith("ms") ? Integer.parseInt(configValue.substring(0, configValue.length() - 2)) : (configValue.endsWith("s") ? Integer.parseInt(configValue.substring(0, configValue.length() - 1)) * 1000 : Integer.parseInt(configValue) * 1000);
            } else {
                Tr.warning((TraceComponent)tc, (String)"file.update.interval.config.invalid.CWMMH01010W", (Object[])new Object[]{configValue});
                this.fileUpdateIntevalMilliseconds = 10000;
            }
            String updateValueMessage = String.format("The fileUpdateInterval is read in as [%s] and is resolved to be [%d] milliseconds", configValue, this.fileUpdateIntevalMilliseconds);
            if (prevConfigIntervalMilliseconds >= 0 && prevConfigIntervalMilliseconds != this.fileUpdateIntevalMilliseconds) {
                updateValueMessage = "The configuration has been updated. " + updateValueMessage;
                this.stopTimers();
                if (this.isFileHealthCheckingEnabled()) {
                    this.startFileHealthCheckProcesses();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)updateValueMessage, (Object[])new Object[0]);
            }
        }
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> properties) {
        if (this.isValidSystemForFileHealthCheck) {
            this.processUpdateIntervalConfig((String)properties.get("fileUpdateInterval"));
        }
    }

    @Override
    public void startFileHealthCheckProcesses() {
        this.isCheckPointFinished = true;
        if (this.isValidSystemForFileHealthCheck && this.isFileHealthCheckingEnabled() && ProductInfo.getBetaEdition()) {
            File startFile = HealthFileUtils.getStartFile();
            File readyFile = HealthFileUtils.getReadyFile();
            File liveFile = HealthFileUtils.getLiveFile();
            if (!startFile.exists() && this.performFileHealthCheck(startFile, "START").equals((Object)HealthCheckResponse.Status.DOWN)) {
                this.startedTimer = new Timer(false);
                this.startedTimer.schedule((TimerTask)new FileUpdateProcess(startFile, "START", true), 0L, 1000L);
            }
            this.performFileHealthCheck(readyFile, "READY");
            this.readyTimer = new Timer(false);
            this.readyTimer.schedule((TimerTask)new FileUpdateProcess(readyFile, "READY"), 0L, (long)this.fileUpdateIntevalMilliseconds);
            this.performFileHealthCheck(liveFile, "LIVE");
            this.liveTimer = new Timer(false);
            this.liveTimer.schedule((TimerTask)new FileUpdateProcess(liveFile, "LIVE"), 0L, (long)this.fileUpdateIntevalMilliseconds);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"HealthCheckServiceImpl is deactivated", (Object[])new Object[0]);
        }
        this.stopTimers();
    }

    private void resolveDefaultStatuses() {
        String mpConfig_defaultReadiness = ConfigProvider.getConfig().getOptionalValue("mp.health.default.readiness.empty.response", String.class).orElse("");
        String mpConfig_defaultStartup = ConfigProvider.getConfig().getOptionalValue("mp.health.default.startup.empty.response", String.class).orElse("");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): The default overall Readiness status was configured to be overriden: mp.health.default.readiness.empty.response=" + mpConfig_defaultReadiness), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): The default overall Startup status was configured to be overriden: mp.health.default.startup.empty.response=" + mpConfig_defaultStartup), (Object[])new Object[0]);
        }
        DEFAULT_READINESS_STATUS = mpConfig_defaultReadiness.equalsIgnoreCase("UP") ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN;
        DEFAULT_STARTUP_STATUS = mpConfig_defaultStartup.equalsIgnoreCase("UP") ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN;
    }

    private Set<String> validateApplicationSet() throws NullPointerException {
        Set<String> apps = this.appTracker.getAllAppNames();
        Set<String> configApps = this.appTracker.getAllConfigAppNames();
        for (String nextAppName : configApps) {
            if (apps.contains(nextAppName)) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): configAdmin found an application that the applicationStateListener already found. configAdminAppName = " + nextAppName), (Object[])new Object[0]);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): applicationStateListener couldn't find application. configAdmin added appName = " + nextAppName), (Object[])new Object[0]);
            }
            this.appTracker.addAppName(nextAppName);
        }
        apps = this.appTracker.getAllAppNames();
        return apps;
    }

    @Override
    public void performHealthCheck(HttpServletRequest request, HttpServletResponse httpResponse) {
        this.performHealthCheck(request, httpResponse, "ALL");
    }

    @Override
    public void performHealthCheck(HttpServletRequest request, HttpServletResponse httpResponse, String healthCheckProcedure) {
        this.resolveDefaultStatuses();
        HealthCheck30HttpResponseBuilder hcHttpResponseBuilder = new HealthCheck30HttpResponseBuilder();
        Set<String> appSet = this.validateApplicationSet();
        HashSet<String> unstartedAppSet = new HashSet<String>();
        this.runHealthChecks(appSet, healthCheckProcedure, unstartedAppSet, status -> hcHttpResponseBuilder.setOverallStatus((HealthCheckResponse.Status)status), x -> hcHttpResponseBuilder.handleUndeterminedResponse(httpResponse), responses -> hcHttpResponseBuilder.addResponses((Set<HealthCheckResponse>)responses));
        this.issueMessagesForUnstartedApps(unstartedAppSet, healthCheckProcedure);
        hcHttpResponseBuilder.setHttpResponse(httpResponse);
    }

    @Override
    public HealthCheckResponse.Status performFileHealthCheck(File file, String healthCheckProcedure) {
        if (!this.isCheckPointFinished) {
            return null;
        }
        if (this.isValidSystemForFileHealthCheck && this.isFileHealthCheckingEnabled() && ProductInfo.getBetaEdition()) {
            this.resolveDefaultStatuses();
            FileHealthCheckBuilder fhc = new FileHealthCheckBuilder(file);
            Set<String> appSet = this.validateApplicationSet();
            HashSet<String> unstartedAppSet = new HashSet<String>();
            this.runHealthChecks(appSet, healthCheckProcedure, unstartedAppSet, status -> fhc.setOverallStatus((HealthCheckResponse.Status)status), x -> fhc.handleUndeterminedResponse(), responses -> fhc.addResponses((Set<HealthCheckResponse>)responses));
            fhc.updateFile();
            this.issueMessagesForUnstartedApps(unstartedAppSet, healthCheckProcedure);
            return fhc.getOverallStatus();
        }
        return null;
    }

    public void issueMessagesForUnstartedApps(Set<String> unstartedAppsSet, String healthCheckProcedure) {
        if (unstartedAppsSet.isEmpty()) {
            this.unstartedAppsCounter.set(0);
        } else if (!unstartedAppsSet.isEmpty() && this.unstartedAppsCounter.get() != unstartedAppsSet.size()) {
            this.unstartedAppsCounter.set(unstartedAppsSet.size());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): numOfUnstartedApps after unstarted app set was updated. = " + this.unstartedAppsCounter.get()), (Object[])new Object[0]);
            }
            if (!unstartedAppsSet.isEmpty()) {
                this.readinessWarningAlreadyShown.set(false);
                this.startupWarningAlreadyShown.set(false);
            } else {
                this.readinessWarningAlreadyShown.set(true);
                this.startupWarningAlreadyShown.set(true);
            }
        }
        if (!unstartedAppsSet.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): numOfUnstartedApps = " + this.unstartedAppsCounter.get()), (Object[])new Object[0]);
            }
            if (healthCheckProcedure.equals("START") && this.startupWarningAlreadyShown.compareAndSet(false, true) && !DEFAULT_STARTUP_STATUS.equals((Object)HealthCheckResponse.Status.UP)) {
                Tr.warning((TraceComponent)tc, (String)"startup.healthcheck.applications.not.started.down.CWMMH0054W", (Object[])new Object[]{unstartedAppsSet});
            } else if (healthCheckProcedure.equals("READY") && this.readinessWarningAlreadyShown.compareAndSet(false, true) && !DEFAULT_READINESS_STATUS.equals((Object)HealthCheckResponse.Status.UP)) {
                Tr.warning((TraceComponent)tc, (String)"readiness.healthcheck.applications.not.started.down.CWMMH0053W", (Object[])new Object[]{unstartedAppsSet});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> void runHealthChecks(Set<String> appSet, String healthCheckProcedure, Set<String> unstartedAppsSet, Consumer<HealthCheckResponse.Status> setOverallStatusFx, Consumer<T> handleUndeterminedFx, Consumer<Set<HealthCheckResponse>> evaluatedStatusFx) {
        Set<HealthCheckResponse> hcResponses = null;
        boolean anyAppsInstalled = false;
        for (String appName : appSet) {
            if (this.appTracker.isInstalled(appName)) {
                anyAppsInstalled = true;
                if (healthCheckProcedure.equals("LIVE") || unstartedAppsSet.contains(appName)) continue;
                unstartedAppsSet.add(appName);
                continue;
            }
            if (!this.appTracker.isUninstalled(appName) && !this.appTracker.isStarted(appName)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): Application : " + appName + " has not started yet."), (Object[])new Object[0]);
                }
                if (!healthCheckProcedure.equals("LIVE")) {
                    if (healthCheckProcedure.equals("START")) {
                        setOverallStatusFx.accept(DEFAULT_STARTUP_STATUS);
                    } else if (healthCheckProcedure.equals("READY")) {
                        setOverallStatusFx.accept(DEFAULT_READINESS_STATUS);
                    } else {
                        setOverallStatusFx.accept(DEFAULT_STARTUP_STATUS.equals((Object)HealthCheckResponse.Status.UP) && DEFAULT_READINESS_STATUS.equals((Object)HealthCheckResponse.Status.UP) ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN);
                    }
                    if (!unstartedAppsSet.contains(appName)) {
                        unstartedAppsSet.add(appName);
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): unstartedAppsSet after adding the unstarted app : " + unstartedAppsSet), (Object[])new Object[0]);
                    continue;
                }
                setOverallStatusFx.accept(HealthCheckResponse.Status.UP);
                continue;
            }
            Set<String> modules = this.appTracker.getModuleNames(appName);
            if (modules == null) continue;
            for (String moduleName : modules) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): appName = " + appName + ", moduleName = " + moduleName), (Object[])new Object[0]);
                }
                try {
                    hcResponses = this.hcExecutor.runHealthChecks(appName, moduleName, healthCheckProcedure);
                }
                catch (HealthCheckBeanCallException healthCheckBeanCallException) {
                    FFDCFilter.processException((Throwable)healthCheckBeanCallException, (String)"io.openliberty.microprofile.health40.internal.HealthCheck40ServiceImpl", (String)"556", (Object)this, (Object[])new Object[]{appSet, healthCheckProcedure, unstartedAppsSet, setOverallStatusFx, handleUndeterminedFx, evaluatedStatusFx});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): Caught the exception " + e + " for appName = " + appName + ", moduleName = " + moduleName), (Object[])new Object[0]);
                    }
                    handleUndeterminedFx.accept(null);
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): hcResponses = " + hcResponses), (Object[])new Object[0]);
                }
                if (hcResponses.isEmpty()) continue;
                evaluatedStatusFx.accept(hcResponses);
            }
        }
        if (anyAppsInstalled && !healthCheckProcedure.equals("LIVE")) {
            setOverallStatusFx.accept(HealthCheckResponse.Status.DOWN);
        }
    }

    @Override
    public void removeModuleReferences(String appName, String moduleName) {
        if (this.hcExecutor != null) {
            this.hcExecutor.removeModuleReferences(appName, moduleName);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class FileUpdateProcess
    extends TimerTask {
        File file;
        String healthCheckProcedure;
        boolean isStopOnCreate = false;
        static final long serialVersionUID = -2115774449540355691L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FileUpdateProcess(File file, String healthCheckProcedure) {
            this(file, healthCheckProcedure, false);
        }

        public FileUpdateProcess(File file, String healthCheckProcedure, boolean isStopOnCreate) {
            this.file = file;
            this.healthCheckProcedure = healthCheckProcedure;
            this.isStopOnCreate = isStopOnCreate;
        }

        @Override
        public void run() {
            HealthCheck40ServiceImpl.this.performFileHealthCheck(this.file, this.healthCheckProcedure);
            if (this.isStopOnCreate && this.file.exists()) {
                this.cancel();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.health40.internal.HealthCheck40ServiceImpl$FileUpdateProcess", FileUpdateProcess.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
        }
    }
}

