/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.ltpakeyutil;

import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.crypto.ltpakeyutil.KeyEncryptor;
import com.ibm.ws.crypto.ltpakeyutil.LTPACrypto;
import com.ibm.ws.crypto.ltpakeyutil.LTPADigSignature;
import com.ibm.ws.crypto.ltpakeyutil.LTPAKeyFileUtility;
import com.ibm.ws.crypto.ltpakeyutil.LTPAKeyPair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Properties;

public class LTPAKeyFileUtilityImpl
implements LTPAKeyFileUtility {
    @Override
    public Properties createLTPAKeysFile(String keyFile, byte[] keyPasswordBytes) throws Exception {
        Properties ltpaProps = this.generateLTPAKeys(keyPasswordBytes, "defaultRealm");
        this.addLTPAKeysToFile(this.getOutputStream(keyFile), ltpaProps);
        return ltpaProps;
    }

    protected final Properties generateLTPAKeys(byte[] keyPasswordBytes, String realm) throws Exception {
        Properties expProps = null;
        KeyEncryptor encryptor = new KeyEncryptor(keyPasswordBytes);
        LTPAKeyPair pair = LTPADigSignature.generateLTPAKeyPair();
        byte[] publicKey = pair.getPublic().getEncoded();
        byte[] privateKey = pair.getPrivate().getEncoded();
        byte[] encryptedPrivateKey = encryptor.encrypt(privateKey);
        byte[] sharedKey = LTPACrypto.generateSharedKey();
        byte[] encryptedSharedKey = encryptor.encrypt(sharedKey);
        String tmpShared = Base64Coder.base64EncodeToString((byte[])encryptedSharedKey);
        String tmpPrivate = Base64Coder.base64EncodeToString((byte[])encryptedPrivateKey);
        String tmpPublic = Base64Coder.base64EncodeToString((byte[])publicKey);
        expProps = new Properties();
        expProps.put("com.ibm.websphere.ltpa.3DESKey", tmpShared);
        expProps.put("com.ibm.websphere.ltpa.PrivateKey", tmpPrivate);
        expProps.put("com.ibm.websphere.ltpa.PublicKey", tmpPublic);
        expProps.put("com.ibm.websphere.ltpa.Realm", realm);
        expProps.put("com.ibm.websphere.CreationHost", "localhost");
        expProps.put("com.ibm.websphere.ltpa.version", "1.0");
        expProps.put("com.ibm.websphere.CreationDate", new Date().toString());
        return expProps;
    }

    private OutputStream getOutputStream(final String keyFile) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws IOException {
                    return new FileOutputStream(new File(keyFile));
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e.getCause());
        }
    }

    protected void addLTPAKeysToFile(OutputStream os, Properties ltpaProps) throws Exception {
        try {
            ltpaProps.store(os, null);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

