/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.FFDCConfigurator;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.logging.internal.impl.FileLogSet;
import com.ibm.ws.logging.internal.impl.ForwardIncident;
import com.ibm.ws.logging.internal.impl.IncidentImpl;
import com.ibm.ws.logging.internal.impl.IncidentSummaryLogger;
import com.ibm.ws.logging.internal.impl.LogProviderConfigImpl;
import com.ibm.ws.logging.internal.impl.LoggingConstants;
import com.ibm.ws.logging.internal.impl.LoggingFileUtils;
import com.ibm.wsspi.logging.IncidentForwarder;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import com.ibm.wsspi.logprovider.FFDCFilterService;
import com.ibm.wsspi.logprovider.LogProviderConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseFFDCService
implements FFDCFilterService {
    private static final TraceComponent tc = Tr.register(BaseFFDCService.class, "logging", "com.ibm.ws.logging.internal.resources.FFDCMessages");
    private final Map<IncidentImpl.Key, IncidentImpl> incidents = new LinkedHashMap<IncidentImpl.Key, IncidentImpl>();
    private volatile File ffdcLogDirectory = null;
    private volatile File summaryFile;
    final FileLogSet summaryLogSet = new FileLogSet(false);
    final FileLogSet ffdcLogSet = new FileLogSet(false);
    private long lastTimeOfDump = Long.MIN_VALUE;
    private int numberOfEntiesProcessed = 0;
    private LoggingConstants.FFDCSummaryPolicy ffdcSummaryPolicy = LoggingConstants.FFDCSummaryPolicy.DEFAULT;
    private static final long lowWaterTime = 60000000000L;
    private static final int normalDumpThreshold = 10;
    private static final long highWaterTime = 300000000000L;

    @Override
    public synchronized void init(LogProviderConfig config) {
        this.ffdcSummaryPolicy = ((LogProviderConfigImpl)config).getFfdcSummaryPolicy();
        this.update(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void update(LogProviderConfig config) {
        File location = config.getLogDirectory();
        if (location == null) {
            location = new File(".");
        }
        this.ffdcLogDirectory = location = new File(location, "ffdc");
        int maxFiles = config.getMaxFiles();
        Object token = ThreadIdentityManager.runAsServer();
        try {
            this.summaryLogSet.update(location, "exception_summary", ".log", maxFiles);
            FileLogSet fileLogSet = this.ffdcLogSet;
            synchronized (fileLogSet) {
                this.ffdcLogSet.update(location, "ffdc", ".log", 0);
            }
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    @Override
    public File getFFDCLogLocation() {
        return this.ffdcLogDirectory;
    }

    @Override
    public synchronized void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Stopping the basic FFDC service", new Object[0]);
        }
        this.logSummary(true);
    }

    @Override
    public void processException(Throwable th, String sourceId, String probeId) {
        this.log(sourceId, probeId, th, null, null);
    }

    @Override
    public void processException(Throwable th, String sourceId, String probeId, Object callerThis) {
        this.log(sourceId, probeId, th, callerThis, null);
    }

    @Override
    public void processException(Throwable th, String sourceId, String probeId, Object[] objectArray) {
        this.log(sourceId, probeId, th, null, objectArray);
    }

    @Override
    public void processException(Throwable th, String sourceId, String probeId, Object callerThis, Object[] objectArray) {
        this.log(sourceId, probeId, th, callerThis, objectArray);
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private void log(String sourceId, String probeId, Throwable th, Object callerThis, Object[] objectArray) {
        IncidentImpl incident = this.getIncident(sourceId, probeId, th);
        incident.log(th, callerThis, objectArray);
        if (System.getSecurityManager() == null) {
            this.logSummary(this.ffdcSummaryPolicy == LoggingConstants.FFDCSummaryPolicy.IMMEDIATE);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    BaseFFDCService.this.logSummary(BaseFFDCService.this.ffdcSummaryPolicy == LoggingConstants.FFDCSummaryPolicy.IMMEDIATE);
                    return null;
                }
            });
        }
        Set<IncidentForwarder> forwarders = FFDC.getIncidentForwarders();
        if (forwarders.size() > 0) {
            ForwardIncident forwardIncident = new ForwardIncident(incident, th, callerThis, objectArray);
            for (IncidentForwarder forwarder : forwarders) {
                forwarder.process(forwardIncident, th);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "FFDC exception: " + th, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IncidentImpl getIncident(String sourceId, String probeId, Throwable th) {
        IncidentImpl.Key key = new IncidentImpl.Key(sourceId, probeId, th);
        IncidentImpl incident = null;
        Map<IncidentImpl.Key, IncidentImpl> map = this.incidents;
        synchronized (map) {
            incident = this.incidents.get(key);
            if (incident == null) {
                incident = new IncidentImpl(this.ffdcLogSet, key);
                this.incidents.put(key, incident);
            }
        }
        return incident;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSummary(boolean force) {
        long currentTime = System.nanoTime();
        if (force || this.dumpAlgorithm(currentTime)) {
            ArrayList<IncidentImpl> incidentCopies;
            Map<IncidentImpl.Key, IncidentImpl> map = this.incidents;
            synchronized (map) {
                incidentCopies = new ArrayList<IncidentImpl>(this.incidents.values());
            }
            this.logSummary(incidentCopies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSummary(List<IncidentImpl> incidents) {
        if (incidents.isEmpty()) {
            return;
        }
        File outFile = this.summaryFile;
        if (outFile == null) {
            outFile = this.summaryFile = this.createNewSummaryFile();
        }
        if (outFile != null) {
            File file = outFile;
            synchronized (file) {
                OutputStream os = null;
                try {
                    os = this.createSummaryStream(outFile);
                    new IncidentSummaryLogger().logIncidentSummary(os, incidents);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException iOException) {
                }
                finally {
                    LoggingFileUtils.tryToClose(os);
                }
            }
        }
    }

    private synchronized boolean dumpAlgorithm(long currentTime) {
        boolean dumpTable = false;
        ++this.numberOfEntiesProcessed;
        if (this.lastTimeOfDump == Long.MIN_VALUE || currentTime - this.lastTimeOfDump > 300000000000L) {
            dumpTable = true;
        } else if (this.numberOfEntiesProcessed > 10 && currentTime - this.lastTimeOfDump > 60000000000L) {
            dumpTable = true;
        }
        if (dumpTable) {
            this.lastTimeOfDump = currentTime;
            this.numberOfEntiesProcessed = 0;
        }
        return dumpTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollLogs() {
        int overage;
        ArrayList<IncidentImpl> incidentCopies;
        this.summaryFile = null;
        Map<IncidentImpl.Key, IncidentImpl> map = this.incidents;
        synchronized (map) {
            incidentCopies = new ArrayList<IncidentImpl>(this.incidents.values());
        }
        if (overage > 0) {
            ArrayList<IncidentImpl> lastSeenIncidents = new ArrayList<IncidentImpl>(incidentCopies);
            Collections.sort(lastSeenIncidents, new Comparator<IncidentImpl>(){

                @Override
                public int compare(IncidentImpl o1, IncidentImpl o2) {
                    return Double.compare(o1.getTimeStamp(), o2.getTimeStamp());
                }
            });
            Map<IncidentImpl.Key, IncidentImpl> map2 = this.incidents;
            synchronized (map2) {
                Iterator i = lastSeenIncidents.iterator();
                for (overage = incidentCopies.size() - 500; i.hasNext() && overage > 0; --overage) {
                    IncidentImpl impl = (IncidentImpl)i.next();
                    i.remove();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "FFDC cleanup -- removing " + impl.key, new Object[0]);
                    }
                    this.incidents.remove(impl.key);
                    impl.cleanup();
                }
            }
        }
        for (IncidentImpl incident : incidentCopies) {
            incident.roll();
        }
        this.logSummary(incidentCopies);
    }

    synchronized File createNewSummaryFile() {
        File newFile;
        Object token = ThreadIdentityManager.runAsServer();
        try {
            newFile = LoggingFileUtils.createNewFile(this.summaryLogSet);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream createSummaryStream(File targetFile) throws IOException {
        if (targetFile == null) {
            return null;
        }
        TextFileOutputStreamFactory factory = FFDCConfigurator.getFileOutputStreamFactory();
        FileOutputStream newStream = null;
        Object token = ThreadIdentityManager.runAsServer();
        try {
            newStream = factory.createOutputStream(targetFile);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return newStream;
    }
}

