/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.util.BaseXML;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RepoXML
extends BaseXML {
    public static final boolean IS_PUBLIC_FEATURE = true;
    public static final boolean IS_VERSIONLESS_FEATURE = true;
    public static final boolean IS_TEST_FEATURE = true;
    public static FeatureResolver.Selector<ProvisioningFeatureDefinition> PUBLIC_NOT_TEST;
    public static FeatureResolver.Selector<ProvisioningFeatureDefinition> IS_NOT_TEST;
    public static FeatureResolver.Selector<ProvisioningFeatureDefinition> IS_PUBLIC;
    public static final String VERSIONLESS_PREFIX = "io.openliberty.versionless.";
    public static FeatureResolver.Selector<ProvisioningFeatureDefinition> IS_CLIENT;
    public static FeatureResolver.Selector<ProvisioningFeatureDefinition> IS_SERVER;
    private static Comparator<ProvisioningFeatureDefinition> COMPARE;
    static final long serialVersionUID = -2542699844243419846L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static FeatureResolver.Selector<ProvisioningFeatureDefinition> featureSelector(final boolean isPublic, final boolean isVersionless, final boolean isTest) {
        return new FeatureResolver.Selector<ProvisioningFeatureDefinition>(){
            static final long serialVersionUID = -230193352288958709L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean test(ProvisioningFeatureDefinition def) {
                return isPublic == RepoXML.isPublic(def) && isVersionless == RepoXML.isVersionless(def) && isTest == RepoXML.isTest(def);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.RepoXML$1", 1.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
    }

    public static boolean isVersionless(ProvisioningFeatureDefinition def) {
        return def.getSymbolicName().startsWith(VERSIONLESS_PREFIX);
    }

    public static boolean isPublic(ProvisioningFeatureDefinition def) {
        return def.getVisibility() == Visibility.PUBLIC;
    }

    public static boolean isTest(ProvisioningFeatureDefinition def) {
        String symbolicName = def.getSymbolicName();
        return symbolicName.startsWith("test.") || symbolicName.startsWith("txtest-");
    }

    public static boolean isClient(ProvisioningFeatureDefinition def) {
        return def.getProcessTypes().contains((Object)ProcessType.CLIENT);
    }

    public static boolean isServer(ProvisioningFeatureDefinition def) {
        return def.getProcessTypes().contains((Object)ProcessType.SERVER);
    }

    public static void write(File file, final List<ProvisioningFeatureDefinition> features) throws Exception {
        RepoXML.write(file, new BaseXML.FailableConsumer<PrintWriter, Exception>(){
            static final long serialVersionUID = -2689285663120162975L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void accept(PrintWriter pW) throws Exception {
                RepoXMLWriter xW = new RepoXMLWriter(pW);
                try {
                    xW.write(features);
                }
                finally {
                    xW.flush();
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.RepoXML$8", 8.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    public static void write(File file, final FeatureResolver.Repository repo) throws Exception {
        RepoXML.write(file, new BaseXML.FailableConsumer<PrintWriter, Exception>(){
            static final long serialVersionUID = -2223149600401697325L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void accept(PrintWriter pW) throws Exception {
                RepoXMLWriter xW = new RepoXMLWriter(pW);
                try {
                    xW.write(repo);
                }
                finally {
                    xW.flush();
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.RepoXML$9", 9.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.RepoXML", RepoXML.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        PUBLIC_NOT_TEST = new FeatureResolver.Selector<ProvisioningFeatureDefinition>(){
            static final long serialVersionUID = -6102768571055267403L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean test(ProvisioningFeatureDefinition def) {
                return RepoXML.isPublic(def) && !RepoXML.isTest(def);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.RepoXML$2", 2.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
        IS_NOT_TEST = new FeatureResolver.Selector<ProvisioningFeatureDefinition>(){
            static final long serialVersionUID = -2120713635613744382L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean test(ProvisioningFeatureDefinition def) {
                return !RepoXML.isTest(def);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.RepoXML$3", 3.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
        IS_PUBLIC = new FeatureResolver.Selector<ProvisioningFeatureDefinition>(){
            static final long serialVersionUID = -1006103362713839808L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean test(ProvisioningFeatureDefinition def) {
                return RepoXML.isPublic(def);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.RepoXML$4", 4.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
        IS_CLIENT = new FeatureResolver.Selector<ProvisioningFeatureDefinition>(){
            static final long serialVersionUID = 6968273433329951155L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean test(ProvisioningFeatureDefinition def) {
                return RepoXML.isClient(def);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.RepoXML$5", 5.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
        IS_SERVER = new FeatureResolver.Selector<ProvisioningFeatureDefinition>(){
            static final long serialVersionUID = 6197785131973346704L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean test(ProvisioningFeatureDefinition def) {
                return RepoXML.isServer(def);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.RepoXML$6", 6.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
        COMPARE = new Comparator<ProvisioningFeatureDefinition>(){
            static final long serialVersionUID = -568824282925966828L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(ProvisioningFeatureDefinition def1, ProvisioningFeatureDefinition def2) {
                return def1.getSymbolicName().compareToIgnoreCase(def2.getSymbolicName());
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.RepoXML$7", 7.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class RepoXMLWriter
    extends BaseXML.BaseXMLWriter {
        static final long serialVersionUID = -1334524303291630968L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public RepoXMLWriter(PrintWriter pW) {
            super(pW);
        }

        public void write(List<ProvisioningFeatureDefinition> features) {
            this.openElement("repository");
            this.upIndent();
            for (ProvisioningFeatureDefinition def : features) {
                this.write(def);
            }
            this.downIndent();
            this.closeElement("repository");
        }

        public void write(FeatureResolver.Repository repo) {
            List<ProvisioningFeatureDefinition> features = repo.getFeatures();
            ProvisioningFeatureDefinition[] featuresArray = features.toArray(new ProvisioningFeatureDefinition[features.size()]);
            Arrays.sort(featuresArray, COMPARE);
            this.openElement("repository");
            this.upIndent();
            for (ProvisioningFeatureDefinition def : featuresArray) {
                this.write(def);
            }
            this.downIndent();
            this.closeElement("repository");
        }

        public void write(ProvisioningFeatureDefinition def) {
            this.openElement("feature");
            this.upIndent();
            this.printElement("file", def.getFeatureDefinitionFile().getName());
            this.printElement("name", def.getFeatureName());
            this.printElement("symbolic-name", def.getSymbolicName());
            this.printOptionalElement("short-name", def.getIbmShortName());
            this.printElement("version", def.getVersion().toString());
            this.printElement("ibm-version", Integer.toString(def.getIbmFeatureVersion()));
            this.printOptionalElement("supported-version", def.isSupportedFeatureVersion());
            this.printElement("visibility", def.getVisibility().toString());
            this.printOptionalElement("auto", def.isAutoFeature());
            this.printOptionalElement("singleton", def.isSingleton());
            this.printOptionalElement("server", def.getProcessTypes().contains("server"));
            this.printOptionalElement("client", def.getProcessTypes().contains("client"));
            this.printElement("restart", def.getAppForceRestart().toString());
            for (FeatureResource resource : def.getConstituents(null)) {
                this.write(resource);
            }
            this.printDelimited("platforms", ", ", def.getPlatformNames());
            this.downIndent();
            this.closeElement("feature");
        }

        public void write(FeatureResource resource) {
            this.openElement("constituent");
            this.upIndent();
            this.printOptionalElement("symbolic-name", resource.getSymbolicName());
            this.printOptionalElement("location", resource.getLocation());
            this.printOptionalElement("start-level", resource.getStartLevel());
            this.printOptionalElement("activation-type", (Object)resource.getActivationType());
            this.printOptionalElement("type", (Object)resource.getType());
            this.printOptionalElement("java-range", resource.getJavaRange());
            this.printOptionalElement("version-range", resource.getVersionRange());
            List<String> tolerates = resource.getTolerates();
            if (tolerates != null && !tolerates.isEmpty()) {
                for (String tolerate : tolerates) {
                    this.printElement("tolerate", tolerate);
                }
            }
            this.downIndent();
            this.closeElement("constituent");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.RepoXML$RepoXMLWriter", RepoXMLWriter.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }
}

