/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.wsspi.logging.LogHandler;
import com.ibm.wsspi.logging.MessageRouter;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.LogRecord;

public class MessageRouterImpl
implements MessageRouter {
    private final ConcurrentMap<String, LogHandler> logHandlerServices = new ConcurrentHashMap<String, LogHandler>();
    private final ConcurrentMap<String, Set<String>> msgIdToLogHandlerIds = new ConcurrentHashMap<String, Set<String>>();

    protected MessageRouterImpl() {
    }

    public void setLogHandler(String id, LogHandler ref) {
        if (id != null && ref != null) {
            this.logHandlerServices.put(id, ref);
        }
    }

    public void unsetLogHandler(String id, LogHandler ref) {
        if (id != null) {
            if (ref == null) {
                this.logHandlerServices.remove(id);
            } else {
                this.logHandlerServices.remove(id, ref);
            }
        }
    }

    protected Set<String> getOrCreateLogHandlerIdSet(String msgId) {
        CopyOnWriteArraySet<String> logHandlerIdSet = (CopyOnWriteArraySet<String>)this.msgIdToLogHandlerIds.get(msgId);
        if (logHandlerIdSet == null) {
            logHandlerIdSet = new CopyOnWriteArraySet<String>();
            this.msgIdToLogHandlerIds.put(msgId, logHandlerIdSet);
            logHandlerIdSet.add("DEFAULT");
        }
        return logHandlerIdSet;
    }

    protected String[] split(String s, String delim) {
        return s != null && !s.trim().isEmpty() ? s.split(delim) : new String[]{};
    }

    public synchronized void modified(Properties props) {
        for (Object key : props.keySet()) {
            String msgId = (String)key;
            String logHandlerIds = props.getProperty(msgId);
            Set<String> logHandlerIdSet = this.getOrCreateLogHandlerIdSet(msgId);
            for (String id : this.split(logHandlerIds, ",")) {
                if ((id = id.trim()).length() <= 0) continue;
                int plusOrMinus = id.charAt(0);
                if (plusOrMinus != 43 && plusOrMinus != 45) {
                    plusOrMinus = 43;
                } else {
                    id = id.substring(1);
                }
                if (id.length() <= 0) continue;
                if (plusOrMinus == 43) {
                    logHandlerIdSet.add(id);
                    continue;
                }
                logHandlerIdSet.remove(id);
            }
            if (logHandlerIdSet.size() != 1 || !logHandlerIdSet.contains("DEFAULT")) continue;
            this.msgIdToLogHandlerIds.remove(msgId);
        }
    }

    protected void addMsgToLogHandler(String msgId, String handlerId) {
        Set<String> logHandlerIdSet = this.getOrCreateLogHandlerIdSet(msgId);
        logHandlerIdSet.add(handlerId);
    }

    protected void removeMsgFromLogHandler(String msgId, String handlerId) {
        Set<String> logHandlerIdSet = this.getOrCreateLogHandlerIdSet(msgId);
        logHandlerIdSet.remove(handlerId);
    }

    protected String parseMessageId(String msg) {
        if (msg == null) {
            return null;
        }
        if (msg.length() >= 10) {
            String msgId = msg.substring(0, 10);
            if (msgId.endsWith(":")) {
                msgId = msgId.substring(0, msgId.indexOf(":"));
            }
            return msgId;
        }
        return null;
    }

    protected Set<String> getLogHandlersForMessage(String msg) {
        if (msg == null) {
            return null;
        }
        return this.getLogHandlersForMsgId(this.parseMessageId(msg));
    }

    protected Set<String> getLogHandlersForMsgId(String msgId) {
        if (msgId == null) {
            return null;
        }
        return (Set)this.msgIdToLogHandlerIds.get(msgId);
    }

    protected boolean isValidMessage(String msg) {
        return msg != null && msg.length() >= 10;
    }

    public boolean route(String msg, LogRecord logRecord) {
        if (!this.isValidMessage(msg)) {
            return true;
        }
        Set<String> logHandlerIdSet = this.getLogHandlersForMessage(msg);
        if (logHandlerIdSet == null) {
            return true;
        }
        return this.routeToAll(msg, logRecord, logHandlerIdSet);
    }

    protected boolean routeToAll(String msg, LogRecord logRecord, Set<String> logHandlerIds) {
        boolean logNormally = false;
        for (String id : logHandlerIds) {
            if (id.equals("DEFAULT")) {
                logNormally = true;
                continue;
            }
            this.routeTo(msg, logRecord, id);
        }
        return logNormally;
    }

    protected void routeTo(String msg, LogRecord logRecord, String logHandlerId) {
        LogHandler logHandler = (LogHandler)this.logHandlerServices.get(logHandlerId);
        if (logHandler != null) {
            logHandler.publish(msg, logRecord);
        }
    }
}

