/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.bundlebee.maven.mojo;

import io.yupiik.bundlebee.core.lang.Tuple2;
import io.yupiik.bundlebee.maven.interpolation.MavenConfigSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;

public abstract class BaseMojo
extends AbstractMojo {
    @Parameter(property="bundlebee.skipMavenForcedFilteringForPlaceholders", defaultValue="false")
    private boolean skipMavenForcedFilteringForPlaceholders;
    @Parameter(property="bundlebee.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="bundlebee.useDefaultLogging", defaultValue="false")
    private boolean useDefaultLogging;
    @Parameter(property="bundlebee.skipPackaging", defaultValue="pom")
    private List<String> skipPackaging;
    @Parameter(defaultValue="${project.packaging}")
    private String packaging;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojoExecution;

    protected abstract void doExecute();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        List<Runnable> reset = Stream.of(this.setupLogger("org.apache.webbeans", Level.WARNING), this.setupLogger("io.yupiik.bundlebee", Level.INFO)).collect(Collectors.toList());
        if (this.skip || this.skipPackaging != null && this.skipPackaging.contains(this.packaging)) {
            this.getLog().info((CharSequence)(((Object)((Object)this)).getClass().getName() + " execution skipped"));
            return;
        }
        if (this.session == null) {
            this.doExecute();
            return;
        }
        MavenSession mavenSession = this.session;
        synchronized (mavenSession) {
            Tuple2 old = new Tuple2((Object)MavenConfigSource.expressionEvaluator, (Object)MavenConfigSource.config);
            MavenConfigSource.expressionEvaluator = new PluginParameterExpressionEvaluator(this.session, this.mojoExecution);
            MavenConfigSource.config = new MavenConfigSource.Config(!this.skipMavenForcedFilteringForPlaceholders);
            try {
                this.doExecute();
            }
            finally {
                reset.forEach(Runnable::run);
                MavenConfigSource.expressionEvaluator = (ExpressionEvaluator)old.getFirst();
                MavenConfigSource.config = (MavenConfigSource.Config)old.getSecond();
            }
        }
    }

    protected Stream<String> toArgs(Map<String, String> placeholders) {
        return placeholders == null ? Stream.empty() : placeholders.entrySet().stream().flatMap(this::loadPlaceholders).flatMap(it -> Stream.of("--" + (String)it.getKey(), (String)it.getValue()));
    }

    private Stream<Map.Entry<String, String>> loadPlaceholders(Map.Entry<String, String> entry) {
        return !entry.getKey().startsWith("bundlebee-placeholder-import") ? Stream.of(entry) : this.loadProperties(entry.getValue());
    }

    private Stream<Map.Entry<String, String>> loadProperties(String value) {
        Properties props = new Properties();
        try (Reader reader = this.resolveReader(value);){
            props.load(reader);
        }
        catch (IOException e2) {
            throw new IllegalArgumentException(e2);
        }
        Stream<Map.Entry<String, String>> base = props.stringPropertyNames().stream().map(k -> Map.entry(k, props.getProperty((String)k)));
        if (this.session == null) {
            return base;
        }
        PluginParameterExpressionEvaluator interpolator = new PluginParameterExpressionEvaluator(this.session, this.mojoExecution);
        return base.map(e -> Map.entry((String)e.getKey(), this.interpolate(interpolator, (String)e.getValue())));
    }

    private String interpolate(PluginParameterExpressionEvaluator interpolator, String value) {
        try {
            Object evaluate = interpolator.evaluate(value);
            return evaluate == null ? value : String.valueOf(evaluate);
        }
        catch (RuntimeException | ExpressionEvaluationException e) {
            this.getLog().debug(e);
            return value;
        }
    }

    private Reader resolveReader(String value) throws IOException {
        Path path = Path.of(value, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return Files.newBufferedReader(path, StandardCharsets.UTF_8);
        }
        InputStream from = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResourceAsStream(value), () -> "Can't find '" + value + "'");
        return new InputStreamReader(from, StandardCharsets.UTF_8);
    }

    private Runnable setupLogger(String name, Level newLevel) {
        Handler[] originalHandlers;
        Logger logger = Logger.getLogger(name);
        boolean originalUseParent = logger.getUseParentHandlers();
        if (!this.useDefaultLogging) {
            originalHandlers = logger.getHandlers();
            Stream.of(originalHandlers).forEach(logger::removeHandler);
            logger.setUseParentHandlers(false);
            logger.addHandler(new ForwardingHandler(this.getLog()));
        } else {
            originalHandlers = new Handler[]{};
        }
        Level oldLevel = logger.getLevel();
        logger.setLevel(newLevel);
        return () -> {
            logger.setLevel(oldLevel);
            logger.setUseParentHandlers(originalUseParent);
            Stream.of(originalHandlers).forEach(logger::addHandler);
        };
    }

    private static class ForwardingHandler
    extends Handler {
        private final Log log;

        @Override
        public void publish(LogRecord record) {
            switch (record.getLevel().getName()) {
                case "INFO": {
                    this.log.info((CharSequence)this.toMessage(record), record.getThrown());
                    break;
                }
                case "WARNING": {
                    this.log.warn((CharSequence)this.toMessage(record), record.getThrown());
                    break;
                }
                case "SEVERE": {
                    this.log.error((CharSequence)this.toMessage(record), record.getThrown());
                    break;
                }
                default: {
                    this.log.debug((CharSequence)this.toMessage(record), record.getThrown());
                }
            }
        }

        private String toMessage(LogRecord record) {
            ResourceBundle catalog = record.getResourceBundle();
            String format = record.getMessage();
            if (catalog != null) {
                try {
                    format = catalog.getString(record.getMessage());
                }
                catch (MissingResourceException ex) {
                    format = record.getMessage();
                }
            }
            try {
                Object[] parameters = record.getParameters();
                if (parameters == null || parameters.length == 0) {
                    return format;
                }
                if (format.contains("{0") || format.contains("{1") || format.contains("{2") || format.contains("{3")) {
                    return MessageFormat.format(format, parameters);
                }
                return format;
            }
            catch (Exception ex) {
                return format;
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
            this.flush();
        }

        @Generated
        public ForwardingHandler(Log log) {
            this.log = log;
        }
    }
}

