/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class TimestampEqualsRule
extends AbstractRule {
    static final long serialVersionUID = 1639079557187790321L;
    private static final LoggingEventFieldResolver RESOLVER = LoggingEventFieldResolver.getInstance();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private long timeStamp;

    private TimestampEqualsRule(String value) {
        try {
            this.timeStamp = DATE_FORMAT.parse(value).getTime();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Could not parse date: " + value);
        }
    }

    public static Rule getRule(String value) {
        return new TimestampEqualsRule(value);
    }

    public boolean evaluate(LoggingEvent event) {
        long eventTimeStamp = Long.parseLong(RESOLVER.getValue("TIMESTAMP", event).toString()) / 1000L * 1000L;
        return eventTimeStamp == this.timeStamp;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.timeStamp = in.readLong();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.timeStamp);
    }
}

