/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.delegation.WrapperWithContext;

public class BiFunctionWithContext<IN1, IN2, OUT>
extends WrapperWithContext<BiFunction<IN1, IN2, OUT>>
implements BiFunction<IN1, IN2, OUT> {
    private static final Logger LOGGER = Logger.getLogger(BiFunctionWithContext.class.getName());

    public BiFunctionWithContext(ContextSnapshot snapshot, BiFunction<IN1, IN2, OUT> delegate) {
        super(snapshot, delegate);
    }

    @Override
    public OUT apply(IN1 in1, IN2 in2) {
        try (Context context = this.snapshot.reactivate();){
            LOGGER.log(Level.FINEST, "Delegating apply method with {0} to {1}.", new Object[]{context, this.delegate()});
            Object r = ((BiFunction)this.nonNullDelegate()).apply(in1, in2);
            return (OUT)r;
        }
    }

    @Override
    public <V> BiFunction<IN1, IN2, V> andThen(Function<? super OUT, ? extends V> after) {
        Objects.requireNonNull(after, "Cannot post-process bi-function with after function <null>.");
        return (in1, in2) -> {
            try (Context context = this.snapshot.reactivate();){
                LOGGER.log(Level.FINEST, "Delegating andThen method with {0} to {1}.", new Object[]{context, this.delegate()});
                Object r = after.apply((OUT)((BiFunction)this.nonNullDelegate()).apply(in1, in2));
                return r;
            }
        };
    }
}

