/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.delegation.WrapperWithContext;

public class BiConsumerWithContext<T, U>
extends WrapperWithContext<BiConsumer<T, U>>
implements BiConsumer<T, U> {
    private static final Logger LOGGER = Logger.getLogger(BiConsumerWithContext.class.getName());

    public BiConsumerWithContext(ContextSnapshot snapshot, BiConsumer<T, U> delegate) {
        super(snapshot, delegate);
    }

    @Override
    public void accept(T t, U u) {
        try (Context context = this.snapshot.reactivate();){
            LOGGER.log(Level.FINEST, "Delegating accept method with {0} to {1}.", new Object[]{context, this.delegate()});
            ((BiConsumer)this.nonNullDelegate()).accept(t, u);
        }
    }

    @Override
    public BiConsumer<T, U> andThen(BiConsumer<? super T, ? super U> after) {
        Objects.requireNonNull(after, "Cannot post-process with after bi-consumer <null>.");
        return (l, r) -> {
            try (Context context = this.snapshot.reactivate();){
                LOGGER.log(Level.FINEST, "Delegating andThen method with {0} to {1}.", new Object[]{context, this.delegate()});
                ((BiConsumer)this.nonNullDelegate()).accept(l, r);
                after.accept(l, r);
            }
        };
    }
}

