/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.delegation.WrapperWithContext;

public class ConsumerWithContext<T>
extends WrapperWithContext<Consumer<T>>
implements Consumer<T> {
    private static final Logger LOGGER = Logger.getLogger(ConsumerWithContext.class.getName());

    public ConsumerWithContext(ContextSnapshot snapshot, Consumer<T> delegate) {
        super(snapshot, delegate);
    }

    @Override
    public void accept(T t) {
        try (Context context = this.snapshot.reactivate();){
            LOGGER.log(Level.FINEST, "Delegating accept method with {0} to {1}.", new Object[]{context, this.delegate()});
            ((Consumer)this.nonNullDelegate()).accept(t);
        }
    }

    @Override
    public Consumer<T> andThen(Consumer<? super T> after) {
        Objects.requireNonNull(after, "Cannot follow consumer with after consumer <null>.");
        return t -> {
            try (Context context = this.snapshot.reactivate();){
                LOGGER.log(Level.FINEST, "Delegating andThen method with {0} to {1}.", new Object[]{context, this.delegate()});
                ((Consumer)this.nonNullDelegate()).accept(t);
                after.accept(t);
            }
        };
    }
}

