/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.delegation.WrapperWithContext;

public class FunctionWithContext<IN, OUT>
extends WrapperWithContext<Function<IN, OUT>>
implements Function<IN, OUT> {
    private static final Logger LOGGER = Logger.getLogger(FunctionWithContext.class.getName());

    public FunctionWithContext(ContextSnapshot snapshot, Function<IN, OUT> delegate) {
        super(snapshot, delegate);
    }

    @Override
    public OUT apply(IN in) {
        try (Context context = this.snapshot.reactivate();){
            LOGGER.log(Level.FINEST, "Delegating apply method with {0} to {1}.", new Object[]{context, this.delegate()});
            Object r = ((Function)this.nonNullDelegate()).apply(in);
            return (OUT)r;
        }
    }

    @Override
    public <V> Function<V, OUT> compose(Function<? super V, ? extends IN> before) {
        Objects.requireNonNull(before, "Cannot compose with before function <null>.");
        return v -> {
            try (Context context = this.snapshot.reactivate();){
                LOGGER.log(Level.FINEST, "Delegating compose method with {0} to {1}.", new Object[]{context, this.delegate()});
                Object r = ((Function)this.nonNullDelegate()).apply(before.apply((Object)v));
                return r;
            }
        };
    }

    @Override
    public <V> Function<IN, V> andThen(Function<? super OUT, ? extends V> after) {
        Objects.requireNonNull(after, "Cannot transform with after function <null>.");
        return in -> {
            try (Context context = this.snapshot.reactivate();){
                LOGGER.log(Level.FINEST, "Delegating andThen method with {0} to {1}.", new Object[]{context, this.delegate()});
                Object r = after.apply((OUT)((Function)this.nonNullDelegate()).apply(in));
                return r;
            }
        };
    }
}

