/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.delegation.WrapperWithContext;

public class PredicateWithContext<T>
extends WrapperWithContext<Predicate<T>>
implements Predicate<T> {
    private static final Logger LOGGER = Logger.getLogger(PredicateWithContext.class.getName());

    public PredicateWithContext(ContextSnapshot snapshot, Predicate<T> delegate) {
        super(snapshot, delegate);
    }

    @Override
    public boolean test(T t) {
        try (Context context = this.snapshot.reactivate();){
            LOGGER.log(Level.FINEST, "Delegating test method with {0} to {1}.", new Object[]{context, this.delegate()});
            boolean bl = ((Predicate)this.nonNullDelegate()).test(t);
            return bl;
        }
    }

    @Override
    public Predicate<T> and(Predicate<? super T> other) {
        Objects.requireNonNull(other, "Cannot combine predicate with 'and' <null>.");
        return t -> {
            try (Context context = this.snapshot.reactivate();){
                LOGGER.log(Level.FINEST, "Delegating 'and' method with {0} to {1}.", new Object[]{context, this.delegate()});
                boolean bl = ((Predicate)this.nonNullDelegate()).test(t) && other.test(t);
                return bl;
            }
        };
    }

    @Override
    public Predicate<T> or(Predicate<? super T> other) {
        Objects.requireNonNull(other, "Cannot combine predicate with 'or' <null>.");
        return t -> {
            try (Context context = this.snapshot.reactivate();){
                LOGGER.log(Level.FINEST, "Delegating 'or' method with {0} to {1}.", new Object[]{context, this.delegate()});
                boolean bl = ((Predicate)this.nonNullDelegate()).test(t) || other.test(t);
                return bl;
            }
        };
    }
}

