/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextManagers;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.functions.WrapperWithContextAndConsumer;

public class FunctionWithContext<IN, OUT>
extends WrapperWithContextAndConsumer<Function<IN, OUT>>
implements Function<IN, OUT> {
    private static final Logger LOGGER = Logger.getLogger(FunctionWithContext.class.getName());

    public FunctionWithContext(ContextSnapshot snapshot, Function<IN, OUT> delegate) {
        this(snapshot, delegate, (Consumer<ContextSnapshot>)null);
    }

    public FunctionWithContext(ContextSnapshot snapshot, Function<IN, OUT> delegate, Consumer<ContextSnapshot> consumer) {
        super(snapshot, delegate, consumer);
    }

    protected FunctionWithContext(Supplier<ContextSnapshot> supplier, Function<IN, OUT> delegate, Consumer<ContextSnapshot> consumer) {
        super(supplier, delegate, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUT apply(IN in) {
        Throwable throwable = null;
        try (Context context = this.snapshot().reactivate();){
            Object r;
            try {
                LOGGER.log(Level.FINEST, "Delegating apply method with {0} to {1}.", new Object[]{context, this.delegate()});
                r = ((Function)this.nonNullDelegate()).apply(in);
                this.consumer().ifPresent(consumer -> {
                    ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                    LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                    consumer.accept(resultSnapshot);
                });
            }
            catch (Throwable throwable2) {
                try {
                    this.consumer().ifPresent(consumer -> {
                        ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                        LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                        consumer.accept(resultSnapshot);
                    });
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            return (OUT)r;
        }
    }

    @Override
    public <V> Function<V, OUT> compose(Function<? super V, ? extends IN> before) {
        Objects.requireNonNull(before, "Cannot compose with before function <null>.");
        return v -> {
            Throwable throwable = null;
            try (Context context = this.snapshot().reactivate();){
                try {
                    LOGGER.log(Level.FINEST, "Delegating compose method with {0} to {1}.", new Object[]{context, this.delegate()});
                    Object r = ((Function)this.nonNullDelegate()).apply(before.apply((Object)v));
                    this.consumer().ifPresent(consumer -> {
                        ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                        LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                        consumer.accept(resultSnapshot);
                    });
                    return r;
                }
                catch (Throwable throwable2) {
                    try {
                        this.consumer().ifPresent(consumer -> {
                            ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                            LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                            consumer.accept(resultSnapshot);
                        });
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
            }
        };
    }

    @Override
    public <V> Function<IN, V> andThen(Function<? super OUT, ? extends V> after) {
        Objects.requireNonNull(after, "Cannot transform with after function <null>.");
        return in -> {
            Throwable throwable = null;
            try (Context context = this.snapshot().reactivate();){
                try {
                    LOGGER.log(Level.FINEST, "Delegating andThen method with {0} to {1}.", new Object[]{context, this.delegate()});
                    Object r = after.apply((OUT)((Function)this.nonNullDelegate()).apply(in));
                    this.consumer().ifPresent(consumer -> {
                        ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                        LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                        consumer.accept(resultSnapshot);
                    });
                    return r;
                }
                catch (Throwable throwable2) {
                    try {
                        this.consumer().ifPresent(consumer -> {
                            ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                            LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                            consumer.accept(resultSnapshot);
                        });
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
            }
        };
    }
}

