/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.futures;

import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.function.Supplier;
import nl.talsmasoftware.context.ContextSnapshot;

final class ContextSnapshotHolder
implements Consumer<ContextSnapshot>,
Supplier<ContextSnapshot> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private ContextSnapshot snapshot;

    ContextSnapshotHolder() {
    }

    @Override
    public void accept(ContextSnapshot snapshot) {
        this.snapshot = snapshot;
        this.latch.countDown();
    }

    @Override
    public ContextSnapshot get() {
        try {
            this.latch.await();
            return this.snapshot;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted waiting for context snapshot.");
        }
    }
}

