/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextManagers;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.functions.WrapperWithContextAndConsumer;

public class RunnableWithContext
extends WrapperWithContextAndConsumer<Runnable>
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(RunnableWithContext.class.getName());

    public RunnableWithContext(ContextSnapshot snapshot, Runnable delegate) {
        this(snapshot, delegate, (Consumer<ContextSnapshot>)null);
    }

    public RunnableWithContext(ContextSnapshot snapshot, Runnable delegate, Consumer<ContextSnapshot> consumer) {
        super(snapshot, delegate, consumer);
    }

    protected RunnableWithContext(Supplier<ContextSnapshot> supplier, Runnable delegate, Consumer<ContextSnapshot> consumer) {
        super(supplier, delegate, consumer);
    }

    @Override
    public void run() {
        try (Context context = this.snapshot().reactivate();){
            try {
                LOGGER.log(Level.FINEST, "Delegating run method with {0} to {1}.", new Object[]{context, this.delegate()});
                ((Runnable)this.nonNullDelegate()).run();
            }
            finally {
                this.consumer().ifPresent(consumer -> {
                    ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                    LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                    consumer.accept(resultSnapshot);
                });
            }
        }
    }
}

