/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.futures;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.functions.BiConsumerWithContext;
import nl.talsmasoftware.context.functions.BiFunctionWithContext;
import nl.talsmasoftware.context.functions.ConsumerWithContext;
import nl.talsmasoftware.context.functions.FunctionWithContext;
import nl.talsmasoftware.context.functions.RunnableWithContext;
import nl.talsmasoftware.context.functions.SupplierWithContext;
import nl.talsmasoftware.context.futures.ContextSnapshotHolder;

public class ContextAwareCompletableFuture<T>
extends CompletableFuture<T> {
    private final ContextSnapshotHolder snapshotHolder;

    public ContextAwareCompletableFuture() {
        this((ContextSnapshot)null);
    }

    public ContextAwareCompletableFuture(ContextSnapshot snapshot) {
        this(new ContextSnapshotHolder(snapshot));
    }

    private ContextAwareCompletableFuture(ContextSnapshotHolder holder) {
        this.snapshotHolder = Objects.requireNonNull(holder, "Snapshot holder is <null>");
    }

    public static <U> ContextAwareCompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return ContextAwareCompletableFuture.supplyAsync(supplier, null, null);
    }

    public static <U> ContextAwareCompletableFuture<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        return ContextAwareCompletableFuture.supplyAsync(supplier, executor, null);
    }

    public static <U> ContextAwareCompletableFuture<U> supplyAsync(Supplier<U> supplier, Executor executor, ContextSnapshot snapshot) {
        ContextSnapshotHolder holder = new ContextSnapshotHolder(snapshot);
        supplier = new SupplierWithContext<U>((Supplier)holder, (Supplier)supplier, (Consumer)holder){};
        return ContextAwareCompletableFuture.wrap(executor == null ? CompletableFuture.supplyAsync(supplier) : CompletableFuture.supplyAsync(supplier, executor), holder);
    }

    public static ContextAwareCompletableFuture<Void> runAsync(Runnable runnable) {
        return ContextAwareCompletableFuture.runAsync(runnable, null, null);
    }

    public static ContextAwareCompletableFuture<Void> runAsync(Runnable runnable, Executor executor) {
        return ContextAwareCompletableFuture.runAsync(runnable, executor, null);
    }

    public static ContextAwareCompletableFuture<Void> runAsync(Runnable runnable, Executor executor, ContextSnapshot snapshot) {
        ContextSnapshotHolder holder = new ContextSnapshotHolder(snapshot);
        runnable = new RunnableWithContext((Supplier)holder, runnable, (Consumer)holder){};
        return ContextAwareCompletableFuture.wrap(executor == null ? CompletableFuture.runAsync(runnable) : CompletableFuture.runAsync(runnable, executor), holder);
    }

    private static <U> ContextAwareCompletableFuture<U> wrap(CompletableFuture<U> completableFuture, ContextSnapshotHolder holder) {
        ContextAwareCompletableFuture contextAwareCompletableFuture = new ContextAwareCompletableFuture(holder);
        completableFuture.whenComplete((T result, U throwable) -> {
            if (throwable != null) {
                contextAwareCompletableFuture.completeExceptionally((Throwable)throwable);
            } else {
                contextAwareCompletableFuture.complete(result);
            }
        });
        return contextAwareCompletableFuture;
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return ContextAwareCompletableFuture.wrap(super.thenApply((Function)new FunctionWithContext(this.snapshotHolder, fn, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return ContextAwareCompletableFuture.wrap(super.thenApplyAsync((Function)new FunctionWithContext(this.snapshotHolder, fn, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.thenApplyAsync((Function)new FunctionWithContext(this.snapshotHolder, fn, this.snapshotHolder){}, executor), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return ContextAwareCompletableFuture.wrap(super.thenAccept((Consumer)new ConsumerWithContext(this.snapshotHolder, action, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return ContextAwareCompletableFuture.wrap(super.thenAcceptAsync((Consumer)new ConsumerWithContext(this.snapshotHolder, action, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.thenAcceptAsync((Consumer)new ConsumerWithContext(this.snapshotHolder, action, this.snapshotHolder){}, executor), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return ContextAwareCompletableFuture.wrap(super.thenRun(new RunnableWithContext(this.snapshotHolder, action, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return ContextAwareCompletableFuture.wrap(super.thenRunAsync(new RunnableWithContext(this.snapshotHolder, action, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.thenRunAsync(new RunnableWithContext(this.snapshotHolder, action, this.snapshotHolder){}, executor), this.snapshotHolder);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return ContextAwareCompletableFuture.wrap(super.thenCombine((CompletionStage)other, (BiFunction)new BiFunctionWithContext(this.snapshotHolder, fn, null){}), this.snapshotHolder);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return ContextAwareCompletableFuture.wrap(super.thenCombineAsync((CompletionStage)other, (BiFunction)new BiFunctionWithContext(this.snapshotHolder, fn, null){}), this.snapshotHolder);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.thenCombineAsync((CompletionStage)other, (BiFunction)new BiFunctionWithContext(this.snapshotHolder, fn, null){}, executor), this.snapshotHolder);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return ContextAwareCompletableFuture.wrap(super.thenAcceptBoth((CompletionStage)other, (BiConsumer)new BiConsumerWithContext(this.snapshotHolder, action, null){}), this.snapshotHolder);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)new BiConsumerWithContext(this.snapshotHolder, action, null){});
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)new BiConsumerWithContext(this.snapshotHolder, action, null){}, executor), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return ContextAwareCompletableFuture.wrap(super.runAfterBoth((CompletionStage)other, (Runnable)new RunnableWithContext(this.snapshotHolder, action, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return ContextAwareCompletableFuture.wrap(super.runAfterBothAsync((CompletionStage)other, (Runnable)new RunnableWithContext(this.snapshotHolder, action, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.runAfterBothAsync((CompletionStage)other, (Runnable)new RunnableWithContext(this.snapshotHolder, action, this.snapshotHolder){}, executor), this.snapshotHolder);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        ContextSnapshot snapshot = this.snapshotHolder.get();
        return ContextAwareCompletableFuture.wrap(super.applyToEither((CompletionStage)other, new FunctionWithContext<T, U>(snapshot, fn)), this.snapshotHolder);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        ContextSnapshot snapshot = this.snapshotHolder.get();
        return ContextAwareCompletableFuture.wrap(super.applyToEitherAsync((CompletionStage)other, new FunctionWithContext<T, U>(snapshot, fn)), this.snapshotHolder);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        ContextSnapshot snapshot = this.snapshotHolder.get();
        return ContextAwareCompletableFuture.wrap(super.applyToEitherAsync((CompletionStage)other, new FunctionWithContext<T, U>(snapshot, fn), executor), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        ContextSnapshot snapshot = this.snapshotHolder.get();
        return ContextAwareCompletableFuture.wrap(super.acceptEither((CompletionStage)other, new ConsumerWithContext<T>(snapshot, action)), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        ContextSnapshot snapshot = this.snapshotHolder.get();
        return ContextAwareCompletableFuture.wrap(super.acceptEitherAsync((CompletionStage)other, new ConsumerWithContext<T>(snapshot, action)), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        ContextSnapshot snapshot = this.snapshotHolder.get();
        return ContextAwareCompletableFuture.wrap(super.acceptEitherAsync((CompletionStage)other, new ConsumerWithContext<T>(snapshot, action), executor), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        ContextSnapshot snapshot = this.snapshotHolder.get();
        return ContextAwareCompletableFuture.wrap(super.runAfterEither((CompletionStage)other, (Runnable)new RunnableWithContext(snapshot, action)), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        ContextSnapshot snapshot = this.snapshotHolder.get();
        return ContextAwareCompletableFuture.wrap(super.runAfterEitherAsync((CompletionStage)other, (Runnable)new RunnableWithContext(snapshot, action)), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        ContextSnapshot snapshot = this.snapshotHolder.get();
        return ContextAwareCompletableFuture.wrap(super.runAfterEitherAsync((CompletionStage)other, (Runnable)new RunnableWithContext(snapshot, action), executor), this.snapshotHolder);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return ContextAwareCompletableFuture.wrap(super.thenCompose((Function)new FunctionWithContext(this.snapshotHolder, fn, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return ContextAwareCompletableFuture.wrap(super.thenComposeAsync((Function)new FunctionWithContext(this.snapshotHolder, fn, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.thenComposeAsync((Function)new FunctionWithContext(this.snapshotHolder, fn, this.snapshotHolder){}, executor), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return ContextAwareCompletableFuture.wrap(super.whenComplete((BiConsumer)new BiConsumerWithContext(this.snapshotHolder, action, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return ContextAwareCompletableFuture.wrap(super.whenCompleteAsync((BiConsumer)new BiConsumerWithContext(this.snapshotHolder, action, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.whenCompleteAsync((BiConsumer)new BiConsumerWithContext(this.snapshotHolder, action, this.snapshotHolder){}, executor), this.snapshotHolder);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return ContextAwareCompletableFuture.wrap(super.handle((BiFunction)new BiFunctionWithContext(this.snapshotHolder, fn, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return ContextAwareCompletableFuture.wrap(super.handleAsync((BiFunction)new BiFunctionWithContext(this.snapshotHolder, fn, this.snapshotHolder){}), this.snapshotHolder);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.handleAsync((BiFunction)new BiFunctionWithContext(this.snapshotHolder, fn, this.snapshotHolder){}, executor), this.snapshotHolder);
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return ContextAwareCompletableFuture.wrap(super.exceptionally((Function)new FunctionWithContext(this.snapshotHolder, fn, this.snapshotHolder){}), this.snapshotHolder);
    }
}

