/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextManagers;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.functions.WrapperWithContextAndConsumer;

public class BiPredicateWithContext<IN1, IN2>
extends WrapperWithContextAndConsumer<BiPredicate<IN1, IN2>>
implements BiPredicate<IN1, IN2> {
    private static final Logger LOGGER = Logger.getLogger(BiPredicateWithContext.class.getName());

    public BiPredicateWithContext(ContextSnapshot snapshot, BiPredicate<IN1, IN2> delegate) {
        this(snapshot, delegate, (Consumer<ContextSnapshot>)null);
    }

    public BiPredicateWithContext(ContextSnapshot snapshot, BiPredicate<IN1, IN2> delegate, Consumer<ContextSnapshot> consumer) {
        super(snapshot, delegate, consumer);
    }

    protected BiPredicateWithContext(Supplier<ContextSnapshot> supplier, BiPredicate<IN1, IN2> delegate, Consumer<ContextSnapshot> consumer) {
        super(supplier, delegate, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(IN1 in1, IN2 in2) {
        Throwable throwable = null;
        try (Context context = this.snapshot().reactivate();){
            boolean bl;
            block16: {
                try {
                    LOGGER.log(Level.FINEST, "Delegating test method with {0} to {1}.", new Object[]{context, this.delegate()});
                    bl = ((BiPredicate)this.nonNullDelegate()).test(in1, in2);
                    if (this.contextSnapshotConsumer == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        if (this.contextSnapshotConsumer != null) {
                            ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                            LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                            this.contextSnapshotConsumer.accept(resultSnapshot);
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                this.contextSnapshotConsumer.accept(resultSnapshot);
            }
            return bl;
        }
    }

    @Override
    public BiPredicate<IN1, IN2> and(BiPredicate<? super IN1, ? super IN2> other) {
        Objects.requireNonNull(other, "Cannot combine bi-predicate with 'and' <null>.");
        return (in1, in2) -> {
            Throwable throwable = null;
            try (Context context = this.snapshot().reactivate();){
                boolean bl;
                block16: {
                    try {
                        LOGGER.log(Level.FINEST, "Delegating 'and' method with {0} to {1}.", new Object[]{context, this.delegate()});
                        boolean bl2 = bl = ((BiPredicate)this.nonNullDelegate()).test(in1, in2) && other.test((IN1)in1, (IN2)in2);
                        if (this.contextSnapshotConsumer == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (this.contextSnapshotConsumer != null) {
                                ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                                LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                                this.contextSnapshotConsumer.accept(resultSnapshot);
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                    LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                    this.contextSnapshotConsumer.accept(resultSnapshot);
                }
                return bl;
            }
        };
    }

    @Override
    public BiPredicate<IN1, IN2> or(BiPredicate<? super IN1, ? super IN2> other) {
        Objects.requireNonNull(other, "Cannot combine bi-predicate with 'or' <null>.");
        return (in1, in2) -> {
            Throwable throwable = null;
            try (Context context = this.snapshot().reactivate();){
                boolean bl;
                block16: {
                    try {
                        LOGGER.log(Level.FINEST, "Delegating 'or' method with {0} to {1}.", new Object[]{context, this.delegate()});
                        boolean bl2 = bl = ((BiPredicate)this.nonNullDelegate()).test(in1, in2) || other.test((IN1)in1, (IN2)in2);
                        if (this.contextSnapshotConsumer == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (this.contextSnapshotConsumer != null) {
                                ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                                LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                                this.contextSnapshotConsumer.accept(resultSnapshot);
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                    LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                    this.contextSnapshotConsumer.accept(resultSnapshot);
                }
                return bl;
            }
        };
    }
}

