/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.futures;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.functions.BiConsumerWithContext;
import nl.talsmasoftware.context.functions.BiFunctionWithContext;
import nl.talsmasoftware.context.functions.ConsumerWithContext;
import nl.talsmasoftware.context.functions.FunctionWithContext;
import nl.talsmasoftware.context.functions.RunnableWithContext;
import nl.talsmasoftware.context.functions.SupplierWithContext;
import nl.talsmasoftware.context.futures.ContextSnapshotHolder;

public class ContextAwareCompletableFuture<T>
extends CompletableFuture<T> {
    private final ContextSnapshotHolder snapshotHolder;
    private final boolean takeNewSnapshot;

    public ContextAwareCompletableFuture() {
        this(null);
    }

    public ContextAwareCompletableFuture(ContextSnapshot snapshot) {
        this(new ContextSnapshotHolder(snapshot), false);
    }

    private ContextAwareCompletableFuture(ContextSnapshotHolder holder, boolean takeNewSnapshot) {
        this.snapshotHolder = Objects.requireNonNull(holder, "Snapshot holder is <null>");
        this.takeNewSnapshot = takeNewSnapshot;
    }

    public static <U> ContextAwareCompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return ContextAwareCompletableFuture.supplyAsync(supplier, null, null, false);
    }

    public static <U> ContextAwareCompletableFuture<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        return ContextAwareCompletableFuture.supplyAsync(supplier, executor, null, false);
    }

    public static <U> ContextAwareCompletableFuture<U> supplyAsync(Supplier<U> supplier, Executor executor, ContextSnapshot snapshot) {
        return ContextAwareCompletableFuture.supplyAsync(supplier, executor, snapshot, false);
    }

    public static <U> ContextAwareCompletableFuture<U> supplyAsync(Supplier<U> supplier, Executor executor, ContextSnapshot snapshot, boolean takeNewSnapshot) {
        ContextSnapshotHolder holder = new ContextSnapshotHolder(snapshot);
        supplier = new SupplierWithContext<U>((Supplier)holder, (Supplier)supplier, (Consumer)(takeNewSnapshot ? holder : null)){};
        return ContextAwareCompletableFuture.wrap(executor == null ? CompletableFuture.supplyAsync(supplier) : CompletableFuture.supplyAsync(supplier, executor), holder, takeNewSnapshot);
    }

    public static ContextAwareCompletableFuture<Void> runAsync(Runnable runnable) {
        return ContextAwareCompletableFuture.runAsync(runnable, null, null, false);
    }

    public static ContextAwareCompletableFuture<Void> runAsync(Runnable runnable, Executor executor) {
        return ContextAwareCompletableFuture.runAsync(runnable, executor, null, false);
    }

    public static ContextAwareCompletableFuture<Void> runAsync(Runnable runnable, Executor executor, ContextSnapshot snapshot) {
        return ContextAwareCompletableFuture.runAsync(runnable, executor, snapshot, false);
    }

    public static ContextAwareCompletableFuture<Void> runAsync(Runnable runnable, Executor executor, ContextSnapshot snapshot, boolean takeNewSnapshot) {
        ContextSnapshotHolder holder = new ContextSnapshotHolder(snapshot);
        runnable = new RunnableWithContext((Supplier)holder, runnable, (Consumer)(takeNewSnapshot ? holder : null)){};
        return ContextAwareCompletableFuture.wrap(executor == null ? CompletableFuture.runAsync(runnable) : CompletableFuture.runAsync(runnable, executor), holder, takeNewSnapshot);
    }

    public static <U> ContextAwareCompletableFuture<U> completedFuture(U value) {
        return ContextAwareCompletableFuture.completedFuture(value, null);
    }

    public static <U> ContextAwareCompletableFuture<U> completedFuture(U value, ContextSnapshot snapshot) {
        ContextAwareCompletableFuture<U> completedFuture = new ContextAwareCompletableFuture<U>(snapshot);
        completedFuture.complete(value);
        return completedFuture;
    }

    public static <U> CompletionStage<U> completedStage(U value) {
        return ContextAwareCompletableFuture.completedFuture(value, null);
    }

    public static <U> ContextAwareCompletableFuture<U> failedFuture(Throwable ex) {
        return ContextAwareCompletableFuture.failedFuture(ex, null);
    }

    public static <U> ContextAwareCompletableFuture<U> failedFuture(Throwable ex, ContextSnapshot snapshot) {
        ContextAwareCompletableFuture failedFuture = new ContextAwareCompletableFuture(snapshot);
        failedFuture.completeExceptionally(ex);
        return failedFuture;
    }

    public static <U> CompletionStage<U> failedStage(Throwable ex) {
        return ContextAwareCompletableFuture.failedFuture(ex, null);
    }

    public static ContextAwareCompletableFuture<Void> allOf(CompletableFuture<?> ... cfs) {
        return ContextAwareCompletableFuture.allOf((ContextSnapshot)null, cfs);
    }

    public static ContextAwareCompletableFuture<Void> allOf(ContextSnapshot snapshot, CompletableFuture<?> ... cfs) {
        ContextSnapshotHolder holder = new ContextSnapshotHolder(snapshot);
        return ContextAwareCompletableFuture.wrap(CompletableFuture.allOf(cfs), holder, false);
    }

    public static ContextAwareCompletableFuture<Object> anyOf(CompletableFuture<?> ... cfs) {
        return ContextAwareCompletableFuture.anyOf((ContextSnapshot)null, cfs);
    }

    public static ContextAwareCompletableFuture<Object> anyOf(ContextSnapshot snapshot, CompletableFuture<?> ... cfs) {
        ContextSnapshotHolder holder = new ContextSnapshotHolder(snapshot);
        return ContextAwareCompletableFuture.wrap(CompletableFuture.anyOf(cfs), holder, false);
    }

    private static <U> ContextAwareCompletableFuture<U> wrap(CompletableFuture<U> completableFuture, ContextSnapshotHolder holder, boolean takeNewSnapshot) {
        ContextAwareCompletableFuture contextAwareCompletableFuture = new ContextAwareCompletableFuture(holder, takeNewSnapshot);
        completableFuture.whenComplete((T result, U throwable) -> {
            if (throwable != null) {
                contextAwareCompletableFuture.completeExceptionally((Throwable)throwable);
            } else {
                contextAwareCompletableFuture.complete(result);
            }
        });
        return contextAwareCompletableFuture;
    }

    private Consumer<ContextSnapshot> resultSnapshotConsumer() {
        return this.takeNewSnapshot ? this.snapshotHolder : null;
    }

    public ContextAwareCompletableFuture<T> takeNewSnapshot() {
        return this.takeNewSnapshot(true);
    }

    public ContextAwareCompletableFuture<T> takeNewSnapshot(boolean takeSnapshot) {
        return this.takeNewSnapshot == takeSnapshot ? this : ContextAwareCompletableFuture.wrap(this, this.snapshotHolder, takeSnapshot);
    }

    @Override
    public <U> ContextAwareCompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return ContextAwareCompletableFuture.wrap(super.thenApply((Function)new FunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U> ContextAwareCompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return ContextAwareCompletableFuture.wrap(super.thenApplyAsync((Function)new FunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U> ContextAwareCompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.thenApplyAsync((Function)new FunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}, executor), this.snapshotHolder, this.takeNewSnapshot);
    }

    public ContextAwareCompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return ContextAwareCompletableFuture.wrap(super.thenAccept((Consumer)new ConsumerWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    public ContextAwareCompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return ContextAwareCompletableFuture.wrap(super.thenAcceptAsync((Consumer)new ConsumerWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    public ContextAwareCompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.thenAcceptAsync((Consumer)new ConsumerWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}, executor), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public ContextAwareCompletableFuture<Void> thenRun(Runnable action) {
        return ContextAwareCompletableFuture.wrap(super.thenRun(new RunnableWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return ContextAwareCompletableFuture.wrap(super.thenRunAsync(new RunnableWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public ContextAwareCompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.thenRunAsync(new RunnableWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}, executor), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U, V> ContextAwareCompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return ContextAwareCompletableFuture.wrap(super.thenCombine((CompletionStage)other, (BiFunction)new BiFunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U, V> ContextAwareCompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return ContextAwareCompletableFuture.wrap(super.thenCombineAsync((CompletionStage)other, (BiFunction)new BiFunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U, V> ContextAwareCompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.thenCombineAsync((CompletionStage)other, (BiFunction)new BiFunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}, executor), this.snapshotHolder, this.takeNewSnapshot);
    }

    public <U> ContextAwareCompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return ContextAwareCompletableFuture.wrap(super.thenAcceptBoth((CompletionStage)other, (BiConsumer)new BiConsumerWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    public <U> ContextAwareCompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return ContextAwareCompletableFuture.wrap(super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)new BiConsumerWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    public <U> ContextAwareCompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)new BiConsumerWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}, executor), this.snapshotHolder, this.takeNewSnapshot);
    }

    public ContextAwareCompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return ContextAwareCompletableFuture.wrap(super.runAfterBoth((CompletionStage)other, (Runnable)new RunnableWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    public ContextAwareCompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return ContextAwareCompletableFuture.wrap(super.runAfterBothAsync((CompletionStage)other, (Runnable)new RunnableWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    public ContextAwareCompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.runAfterBothAsync((CompletionStage)other, (Runnable)new RunnableWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}, executor), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U> ContextAwareCompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return ContextAwareCompletableFuture.wrap(super.applyToEither((CompletionStage)other, (Function)new FunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U> ContextAwareCompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return ContextAwareCompletableFuture.wrap(super.applyToEitherAsync((CompletionStage)other, (Function)new FunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U> ContextAwareCompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.applyToEitherAsync((CompletionStage)other, (Function)new FunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}, executor), this.snapshotHolder, this.takeNewSnapshot);
    }

    public ContextAwareCompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return ContextAwareCompletableFuture.wrap(super.acceptEither((CompletionStage)other, (Consumer)new ConsumerWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    public ContextAwareCompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return ContextAwareCompletableFuture.wrap(super.acceptEitherAsync((CompletionStage)other, (Consumer)new ConsumerWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    public ContextAwareCompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.acceptEitherAsync((CompletionStage)other, (Consumer)new ConsumerWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}, executor), this.snapshotHolder, this.takeNewSnapshot);
    }

    public ContextAwareCompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return ContextAwareCompletableFuture.wrap(super.runAfterEither((CompletionStage)other, (Runnable)new RunnableWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    public ContextAwareCompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return ContextAwareCompletableFuture.wrap(super.runAfterEitherAsync((CompletionStage)other, (Runnable)new RunnableWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    public ContextAwareCompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.runAfterEitherAsync((CompletionStage)other, (Runnable)new RunnableWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}, executor), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U> ContextAwareCompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return ContextAwareCompletableFuture.wrap(super.thenCompose((Function)new FunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U> ContextAwareCompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return ContextAwareCompletableFuture.wrap(super.thenComposeAsync((Function)new FunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U> ContextAwareCompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.thenComposeAsync((Function)new FunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}, executor), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public ContextAwareCompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return ContextAwareCompletableFuture.wrap(super.whenComplete((BiConsumer)new BiConsumerWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public ContextAwareCompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return ContextAwareCompletableFuture.wrap(super.whenCompleteAsync((BiConsumer)new BiConsumerWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public ContextAwareCompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.whenCompleteAsync((BiConsumer)new BiConsumerWithContext(this.snapshotHolder, action, this.resultSnapshotConsumer()){}, executor), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U> ContextAwareCompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return ContextAwareCompletableFuture.wrap(super.handle((BiFunction)new BiFunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U> ContextAwareCompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return ContextAwareCompletableFuture.wrap(super.handleAsync((BiFunction)new BiFunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public <U> ContextAwareCompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return ContextAwareCompletableFuture.wrap(super.handleAsync((BiFunction)new BiFunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}, executor), this.snapshotHolder, this.takeNewSnapshot);
    }

    @Override
    public ContextAwareCompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return ContextAwareCompletableFuture.wrap(super.exceptionally((Function)new FunctionWithContext(this.snapshotHolder, fn, this.resultSnapshotConsumer()){}), this.snapshotHolder, this.takeNewSnapshot);
    }
}

