/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextManagers;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.functions.WrapperWithContextAndConsumer;

public class BiConsumerWithContext<T, U>
extends WrapperWithContextAndConsumer<BiConsumer<T, U>>
implements BiConsumer<T, U> {
    private static final Logger LOGGER = Logger.getLogger(BiConsumerWithContext.class.getName());

    public BiConsumerWithContext(ContextSnapshot snapshot, BiConsumer<T, U> delegate) {
        this(snapshot, delegate, (Consumer<ContextSnapshot>)null);
    }

    public BiConsumerWithContext(ContextSnapshot snapshot, BiConsumer<T, U> delegate, Consumer<ContextSnapshot> consumer) {
        super(snapshot, delegate, consumer);
    }

    protected BiConsumerWithContext(Supplier<ContextSnapshot> supplier, BiConsumer<T, U> delegate, Consumer<ContextSnapshot> consumer) {
        super(supplier, delegate, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(T t, U u) {
        try (Context context = this.snapshot().reactivate();){
            try {
                LOGGER.log(Level.FINEST, "Delegating accept method with {0} to {1}.", new Object[]{context, this.delegate()});
                ((BiConsumer)this.nonNullDelegate()).accept(t, u);
            }
            finally {
                if (this.contextSnapshotConsumer != null) {
                    ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                    LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                    this.contextSnapshotConsumer.accept(resultSnapshot);
                }
            }
        }
    }

    @Override
    public BiConsumer<T, U> andThen(BiConsumer<? super T, ? super U> after) {
        Objects.requireNonNull(after, "Cannot post-process with after bi-consumer <null>.");
        return (l, r) -> {
            try (Context context = this.snapshot().reactivate();){
                try {
                    LOGGER.log(Level.FINEST, "Delegating andThen method with {0} to {1}.", new Object[]{context, this.delegate()});
                    ((BiConsumer)this.nonNullDelegate()).accept(l, r);
                    after.accept(l, r);
                }
                finally {
                    if (this.contextSnapshotConsumer != null) {
                        ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                        LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                        this.contextSnapshotConsumer.accept(resultSnapshot);
                    }
                }
            }
        };
    }
}

