/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextManagers;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.functions.WrapperWithContextAndConsumer;

public class BooleanSupplierWithContext
extends WrapperWithContextAndConsumer<BooleanSupplier>
implements BooleanSupplier {
    private static final Logger LOGGER = Logger.getLogger(BooleanSupplierWithContext.class.getName());

    public BooleanSupplierWithContext(ContextSnapshot snapshot, BooleanSupplier delegate) {
        this(snapshot, delegate, (Consumer<ContextSnapshot>)null);
    }

    public BooleanSupplierWithContext(ContextSnapshot snapshot, BooleanSupplier delegate, Consumer<ContextSnapshot> consumer) {
        super(snapshot, delegate, consumer);
    }

    protected BooleanSupplierWithContext(Supplier<ContextSnapshot> supplier, BooleanSupplier delegate, Consumer<ContextSnapshot> consumer) {
        super(supplier, delegate, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAsBoolean() {
        Throwable throwable = null;
        try (Context context = this.snapshot().reactivate();){
            try {
                LOGGER.log(Level.FINEST, "Delegating getAsBoolean method with {0} to {1}.", new Object[]{context, this.delegate()});
                boolean bl = ((BooleanSupplier)this.nonNullDelegate()).getAsBoolean();
                this.consumer().ifPresent(consumer -> {
                    ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                    LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                    consumer.accept(resultSnapshot);
                });
                return bl;
            }
            catch (Throwable throwable2) {
                try {
                    this.consumer().ifPresent(consumer -> {
                        ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                        LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                        consumer.accept(resultSnapshot);
                    });
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
    }
}

