/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cookie;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.cookie.CookieProvider;
import org.keycloak.cookie.CookieProviderFactory;
import org.keycloak.cookie.DefaultCookieProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class DefaultCookieProviderFactory
implements CookieProviderFactory {
    private static final String SAME_SITE_LEGACY_KEY = "sameSiteLegacy";
    private boolean sameSiteLegacyEnabled;

    public CookieProvider create(KeycloakSession session) {
        return new DefaultCookieProvider(session.getContext(), this.sameSiteLegacyEnabled);
    }

    public void init(Config.Scope config) {
        this.sameSiteLegacyEnabled = config.getBoolean(SAME_SITE_LEGACY_KEY, Boolean.valueOf(true));
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(SAME_SITE_LEGACY_KEY).type("boolean").helpText("Adds legacy cookies without SameSite parameter").defaultValue((Object)true).add().build();
    }
}

