/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.protocol.mappers.oidc;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.keycloak.common.util.TriFunction;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeDecorator;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.UserModel;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.utils.StringUtil;

public enum OrganizationScope {
    ALL("*"::equals, (TriFunction<UserModel, String, KeycloakSession, Stream<OrganizationModel>>)((TriFunction)(user, scopes, session) -> {
        if (user == null) {
            return Stream.empty();
        }
        return Organizations.getProvider(session).getByMember(user);
    }), organizations -> true, (current, previous) -> OrganizationScope.valueOfScope(current) == null ? previous : current),
    SINGLE(StringUtil::isNotBlank, (TriFunction<UserModel, String, KeycloakSession, Stream<OrganizationModel>>)((TriFunction)(user, scopes, session) -> {
        OrganizationModel organization = OrganizationScope.parseScopeParameter(scopes).map(OrganizationScope::parseScopeValue).map(alias -> Organizations.getProvider(session).getByAlias(alias)).filter(Objects::nonNull).findAny().orElse(null);
        if (organization == null) {
            return Stream.empty();
        }
        if (user == null || organization.isMember(user)) {
            return Stream.of(organization);
        }
        return Stream.empty();
    }), organizations -> organizations.findAny().isPresent(), (current, previous) -> {
        if (current.equals(previous)) {
            return current;
        }
        if (ALL.equals((Object)OrganizationScope.valueOfScope(current))) {
            return previous;
        }
        return null;
    }),
    ANY(""::equals, (TriFunction<UserModel, String, KeycloakSession, Stream<OrganizationModel>>)((TriFunction)(user, scopes, session) -> {
        if (user == null) {
            return Stream.empty();
        }
        List organizations = Organizations.getProvider(session).getByMember(user).toList();
        if (organizations.size() == 1) {
            return organizations.stream();
        }
        ClientSessionContext context = (ClientSessionContext)session.getAttribute(ClientSessionContext.class.getName());
        if (context == null) {
            return Stream.empty();
        }
        AuthenticatedClientSessionModel clientSession = context.getClientSession();
        String orgId = clientSession.getNote("kc.org");
        if (orgId == null) {
            return Stream.empty();
        }
        return organizations.stream().filter(o -> o.getId().equals(orgId));
    }), organizations -> true, (current, previous) -> {
        if (current.equals(previous)) {
            return current;
        }
        if (ALL.equals((Object)OrganizationScope.valueOfScope(current))) {
            return previous;
        }
        return null;
    });

    private static final Pattern SCOPE_PATTERN;
    private final Predicate<String> valueMatcher;
    private final TriFunction<UserModel, String, KeycloakSession, Stream<OrganizationModel>> valueResolver;
    private final Predicate<Stream<OrganizationModel>> valueValidator;
    private final BiFunction<String, String, String> nameResolver;

    private OrganizationScope(Predicate<String> valueMatcher, TriFunction<UserModel, String, KeycloakSession, Stream<OrganizationModel>> valueResolver, Predicate<Stream<OrganizationModel>> valueValidator, BiFunction<String, String, String> nameResolver) {
        this.valueMatcher = valueMatcher;
        this.valueResolver = valueResolver;
        this.valueValidator = valueValidator;
        this.nameResolver = nameResolver;
    }

    public Stream<OrganizationModel> resolveOrganizations(UserModel user, String scope, KeycloakSession session) {
        if (scope == null) {
            return Stream.empty();
        }
        return ((Stream)this.valueResolver.apply((Object)user, (Object)scope, (Object)session)).filter(OrganizationModel::isEnabled);
    }

    public ClientScopeModel toClientScope(String name, UserModel user, KeycloakSession session) {
        OrganizationScope scope = OrganizationScope.valueOfScope(name);
        if (scope == null) {
            return null;
        }
        KeycloakContext context = session.getContext();
        ClientModel client = context.getClient();
        ClientScopeModel orgScope = this.getOrganizationClientScope(client, session);
        if (orgScope == null) {
            return null;
        }
        Stream<OrganizationModel> organizations = scope.resolveOrganizations(user, name, session);
        if (this.valueValidator.test(organizations)) {
            return new ClientScopeDecorator(orgScope, name);
        }
        return null;
    }

    public String resolveName(Set<String> scopes, String previous) {
        for (String scope : scopes) {
            String resolved = this.nameResolver.apply(scope, previous);
            if (resolved == null) continue;
            return resolved;
        }
        return null;
    }

    public static OrganizationScope valueOfScope(String rawScope) {
        if (rawScope == null) {
            return null;
        }
        return OrganizationScope.parseScopeParameter(rawScope).map(s -> {
            for (OrganizationScope scope : OrganizationScope.values()) {
                if (!scope.valueMatcher.test(OrganizationScope.parseScopeValue(s))) continue;
                return scope;
            }
            return null;
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    private static String parseScopeValue(String scope) {
        if (!OrganizationScope.hasOrganizationScope(scope)) {
            return null;
        }
        if (scope.equals("organization")) {
            return "";
        }
        Matcher matcher = SCOPE_PATTERN.matcher(scope);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private ClientScopeModel getOrganizationClientScope(ClientModel client, KeycloakSession session) {
        if (!Organizations.isEnabledAndOrganizationsPresent(session)) {
            return null;
        }
        HashMap scopes = new HashMap(client.getClientScopes(true));
        scopes.putAll(client.getClientScopes(false));
        return (ClientScopeModel)scopes.get("organization");
    }

    private static boolean hasOrganizationScope(String scope) {
        return scope != null && scope.contains("organization");
    }

    private static Stream<String> parseScopeParameter(String rawScope) {
        return TokenManager.parseScopeParameter(rawScope).filter(OrganizationScope::hasOrganizationScope);
    }

    static {
        SCOPE_PATTERN = Pattern.compile("organization" + ":*".replace("*", "(.*)"));
    }
}

