/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerWellKnownProvider;
import org.keycloak.protocol.oid4vc.issuance.VCIssuanceContext;
import org.keycloak.protocol.oid4vc.issuance.VCIssuerException;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningService;
import org.keycloak.protocol.oid4vc.model.Proof;
import org.keycloak.protocol.oid4vc.model.ProofTypeJWT;
import org.keycloak.protocol.oid4vc.model.ProofTypesSupported;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;
import org.keycloak.representations.AccessToken;
import org.keycloak.util.JsonSerialization;

public abstract class JwtProofBasedSigningService<T>
extends SigningService<T> {
    private static final Logger LOGGER = Logger.getLogger(JwtProofBasedSigningService.class);
    private static final String CRYPTOGRAPHIC_BINDING_METHOD_JWK = "jwk";
    public static final String PROOF_JWT_TYP = "openid4vci-proof+jwt";

    protected JwtProofBasedSigningService(KeycloakSession keycloakSession, String keyId, String format, String type) {
        super(keycloakSession, keyId, format, type);
    }

    protected JWK validateProof(VCIssuanceContext vcIssuanceContext) throws VCIssuerException, JWSInputException, VerificationException, IOException {
        Optional<Proof> optionalProof = this.getProofFromContext(vcIssuanceContext);
        if (optionalProof.isEmpty()) {
            return null;
        }
        this.checkCryptographicKeyBinding(vcIssuanceContext);
        JWSInput jwsInput = this.getJwsInput(optionalProof.get());
        JWSHeader jwsHeader = jwsInput.getHeader();
        this.validateJwsHeader(vcIssuanceContext, jwsHeader);
        JWK jwk = Optional.ofNullable(jwsHeader.getKey()).orElseThrow(() -> new VCIssuerException("Missing binding key. Make sure provided JWT contains the jwk jwsHeader claim."));
        AccessToken proofPayload = (AccessToken)JsonSerialization.readValue((byte[])jwsInput.getContent(), AccessToken.class);
        this.validateProofPayload(vcIssuanceContext, proofPayload);
        SignatureVerifierContext signatureVerifierContext = this.getVerifier(jwk, jwsHeader.getAlgorithm().name());
        if (signatureVerifierContext == null) {
            throw new VCIssuerException("No verifier configured for " + jwsHeader.getAlgorithm());
        }
        if (!signatureVerifierContext.verify(jwsInput.getEncodedSignatureInput().getBytes(StandardCharsets.UTF_8), jwsInput.getSignature())) {
            throw new VCIssuerException("Could not verify provided proof");
        }
        return jwk;
    }

    private void checkCryptographicKeyBinding(VCIssuanceContext vcIssuanceContext) {
        if (vcIssuanceContext.getCredentialConfig().getCryptographicBindingMethodsSupported() == null || !vcIssuanceContext.getCredentialConfig().getCryptographicBindingMethodsSupported().contains(CRYPTOGRAPHIC_BINDING_METHOD_JWK)) {
            throw new IllegalStateException("This SD-JWT implementation only supports jwk as cryptographic binding method");
        }
    }

    private Optional<Proof> getProofFromContext(VCIssuanceContext vcIssuanceContext) throws VCIssuerException {
        return Optional.ofNullable(vcIssuanceContext.getCredentialConfig()).map(SupportedCredentialConfiguration::getProofTypesSupported).flatMap(proofTypesSupported -> {
            Optional.ofNullable(proofTypesSupported.getJwt()).orElseThrow(() -> new VCIssuerException("SD-JWT supports only jwt proof type."));
            Proof proof = Optional.ofNullable(vcIssuanceContext.getCredentialRequest().getProof()).orElseThrow(() -> new VCIssuerException("Credential configuration requires a proof of type: jwt"));
            if (!Objects.equals(proof.getProofType(), "jwt")) {
                throw new VCIssuerException("Wrong proof type");
            }
            return Optional.of(proof);
        });
    }

    private JWSInput getJwsInput(Proof proof) throws JWSInputException {
        return new JWSInput(proof.getJwt());
    }

    private void validateJwsHeader(VCIssuanceContext vcIssuanceContext, JWSHeader jwsHeader) throws VCIssuerException {
        Optional.ofNullable(jwsHeader.getAlgorithm()).orElseThrow(() -> new VCIssuerException("Missing jwsHeader claim alg"));
        Optional.ofNullable(vcIssuanceContext.getCredentialConfig()).map(SupportedCredentialConfiguration::getProofTypesSupported).map(ProofTypesSupported::getJwt).map(ProofTypeJWT::getProofSigningAlgValuesSupported).filter(supportedAlgs -> supportedAlgs.contains(jwsHeader.getAlgorithm().name())).orElseThrow(() -> new VCIssuerException("Proof signature algorithm not supported: " + jwsHeader.getAlgorithm().name()));
        Optional.ofNullable(jwsHeader.getType()).filter(type -> Objects.equals(PROOF_JWT_TYP, type)).orElseThrow(() -> new VCIssuerException("JWT type must be: openid4vci-proof+jwt"));
        Optional.ofNullable(jwsHeader.getKeyId()).ifPresent(keyId -> {
            throw new VCIssuerException("KeyId not expected in this JWT. Use the jwk claim instead.");
        });
    }

    private void validateProofPayload(VCIssuanceContext vcIssuanceContext, AccessToken proofPayload) throws VCIssuerException {
        String credentialIssuer = OID4VCIssuerWellKnownProvider.getIssuer(this.keycloakSession.getContext());
        Optional.ofNullable(proofPayload.getAudience()).map(Arrays::asList).filter(audiences -> audiences.contains(credentialIssuer)).orElseThrow(() -> new VCIssuerException("Proof not produced for this audience. Audience claim must be: " + credentialIssuer + " but are " + Arrays.asList(proofPayload.getAudience())));
        Optional.ofNullable(proofPayload.getIat()).orElseThrow(() -> new VCIssuerException("Missing proof issuing time. iat claim must be provided."));
        Optional.ofNullable(vcIssuanceContext.getAuthResult().getToken().getNonce()).ifPresent(cNonce -> Optional.ofNullable(proofPayload.getNonce()).filter(nonce -> Objects.equals(cNonce, nonce)).orElseThrow(() -> new VCIssuerException("Missing or wrong nonce value. Please provide nonce returned by the issuer if any.")));
    }
}

