/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.common.Profile;
import org.keycloak.common.Version;
import org.keycloak.common.util.Environment;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.utils.PkceUtils;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resource.AccountResourceProvider;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.Chunk;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.services.util.ViteManifest;
import org.keycloak.services.validation.Validation;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.Theme;
import org.keycloak.theme.beans.MessageFormatterMethod;
import org.keycloak.theme.freemarker.FreeMarkerProvider;
import org.keycloak.urls.UrlType;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.SecureContextResolver;
import org.keycloak.utils.StringUtil;

public class AccountConsole
implements AccountResourceProvider {
    public static final String ACCOUNT_MGMT_FORWARDED_ERROR_NOTE = "ACCOUNT_MGMT_FORWARDED_ERROR";
    private final Pattern bundleParamPattern = Pattern.compile("(\\{\\s*(\\d+)\\s*\\})");
    protected final KeycloakSession session;
    private final AppAuthManager authManager;
    private final RealmModel realm;
    private final ClientModel client;
    private final Theme theme;
    private Auth auth;

    public AccountConsole(KeycloakSession session, ClientModel client, Theme theme) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.client = client;
        this.theme = theme;
        this.authManager = new AppAuthManager();
        this.init();
    }

    public void init() {
        AuthenticationManager.AuthResult authResult = this.authManager.authenticateIdentityCookie(this.session, this.realm);
        if (authResult != null) {
            this.auth = new Auth(this.realm, authResult.getToken(), authResult.getUser(), this.client, authResult.getSession(), true);
        }
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    @GET
    @NoCache
    @Path(value="{path:.*}")
    public Response getMainPage(@PathParam(value="path") String path) throws IOException, FreeMarkerException {
        if (this.auth == null) {
            return this.redirectToLogin(path);
        }
        return this.renderAccountConsole();
    }

    private Response renderAccountConsole() throws IOException, FreeMarkerException {
        String devServerUrl;
        String[] referrer;
        KeycloakUriInfo serverUriInfo = this.session.getContext().getUri(UrlType.FRONTEND);
        URI serverBaseUri = serverUriInfo.getBaseUri();
        String serverBaseUrl = serverBaseUri.toString().replaceFirst("/+$", "");
        HashMap<String, Object> map = new HashMap<String, Object>();
        URI accountBaseUrl = serverUriInfo.getBaseUriBuilder().path(RealmsResource.class).path(this.realm.getName()).path("account").path("/").build(new Object[]{this.realm});
        boolean isSecureContext = SecureContextResolver.isSecureContext(this.session);
        map.put("isSecureContext", isSecureContext);
        map.put("serverBaseUrl", serverBaseUrl);
        map.put("authUrl", serverBaseUrl + "/");
        map.put("authServerUrl", serverBaseUrl + "/");
        map.put("baseUrl", accountBaseUrl.getPath().endsWith("/") ? accountBaseUrl : accountBaseUrl + "/");
        map.put("realm", this.realm);
        map.put("clientId", "account-console");
        map.put("resourceUrl", Urls.themeRoot(serverBaseUri).getPath() + "/account/" + this.theme.getName());
        map.put("resourceCommonUrl", Urls.themeRoot(serverBaseUri).getPath() + "/common/keycloak");
        map.put("resourceVersion", Version.RESOURCES_VERSION);
        MultivaluedMap queryParameters = this.session.getContext().getUri().getQueryParameters();
        String requestedScopes = (String)queryParameters.getFirst((Object)"scope");
        if (requestedScopes == null) {
            requestedScopes = AuthenticationManager.getRequestedScopes(this.session, this.realm.getClientByClientId("account-console"));
        }
        if (requestedScopes != null) {
            map.put("scope", requestedScopes);
        }
        if ((referrer = this.getReferrer()) != null) {
            map.put("referrer", referrer[0]);
            map.put("referrerName", referrer[1]);
            map.put("referrer_uri", referrer[2]);
        }
        UserModel user = null;
        if (this.auth != null) {
            user = this.auth.getUser();
        }
        Locale locale = this.session.getContext().resolveLocale(user);
        map.put("locale", locale.toLanguageTag());
        Properties messages = this.theme.getEnhancedMessages(this.realm, locale);
        map.put("msg", new MessageFormatterMethod(locale, messages));
        map.put("msgJSON", this.messagesToJsonString(messages));
        map.put("supportedLocales", this.supportedLocales(messages));
        map.put("properties", this.theme.getProperties());
        map.put("darkMode", "true".equals(this.theme.getProperties().getProperty("darkMode")) && this.realm.getAttribute("darkMode", Boolean.valueOf(true)) != false);
        map.put("theme", file -> {
            try {
                InputStream resource = this.theme.getResourceAsStream(file);
                return new Scanner(resource, StandardCharsets.UTF_8).useDelimiter("\\A").next();
            }
            catch (IOException e) {
                throw new RuntimeException("could not load file", e);
            }
        });
        map.put("isAuthorizationEnabled", Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION));
        boolean deleteAccountAllowed = false;
        boolean isViewGroupsEnabled = false;
        if (user != null) {
            RoleModel deleteAccountRole = this.realm.getClientByClientId("account").getRole("delete-account");
            deleteAccountAllowed = deleteAccountRole != null && user.hasRole(deleteAccountRole) && this.realm.getRequiredActionProviderByAlias("delete_account").isEnabled();
            RoleModel viewGrouRole = this.realm.getClientByClientId("account").getRole("view-groups");
            isViewGroupsEnabled = viewGrouRole != null && user.hasRole(viewGrouRole);
        }
        map.put("deleteAccountAllowed", deleteAccountAllowed);
        map.put("isViewGroupsEnabled", isViewGroupsEnabled);
        map.put("isViewOrganizationsEnabled", this.realm.isOrganizationsEnabled());
        map.put("isOid4VciEnabled", this.realm.isVerifiableCredentialsEnabled());
        map.put("updateEmailFeatureEnabled", Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL));
        RequiredActionProviderModel updateEmailActionProvider = this.realm.getRequiredActionProviderByAlias(UserModel.RequiredAction.UPDATE_EMAIL.name());
        map.put("updateEmailActionEnabled", updateEmailActionProvider != null && updateEmailActionProvider.isEnabled());
        String string = devServerUrl = Environment.isDevMode() ? System.getenv("KC_ACCOUNT_VITE_URL") : null;
        if (devServerUrl != null) {
            map.put("devServerUrl", devServerUrl);
        }
        InputStream manifestFile = this.theme.getResourceAsStream(".vite/manifest.json");
        if (devServerUrl == null && manifestFile != null) {
            ViteManifest manifest = ViteManifest.parseFromInputStream(manifestFile);
            Chunk entryChunk = manifest.getEntryChunk();
            String[] entryStyles = entryChunk.css().orElse(new String[0]);
            String entryScript = entryChunk.file();
            String[] entryImports = entryChunk.imports().orElse(new String[0]);
            map.put("entryStyles", entryStyles);
            map.put("entryScript", entryScript);
            map.put("entryImports", entryImports);
        }
        FreeMarkerProvider freeMarkerUtil = (FreeMarkerProvider)this.session.getProvider(FreeMarkerProvider.class);
        String result = freeMarkerUtil.processTemplate(map, "index.ftl", this.theme);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK).type("text/html; charset=utf-8").language(Locale.ENGLISH).entity((Object)result);
        return builder.build();
    }

    private Response redirectToLogin(String path) {
        String pkceChallenge;
        MultivaluedMap queryParameters;
        UriBuilder consoleUriBuilder = Urls.accountBase(this.session.getContext().getUri().getBaseUri());
        if (!StringUtil.isNullOrEmpty((String)path)) {
            consoleUriBuilder.path(path);
        }
        if (!(queryParameters = this.session.getContext().getUri().getQueryParameters()).isEmpty()) {
            String referrerUri;
            String referrer = (String)queryParameters.getFirst((Object)"referrer");
            if (referrer != null) {
                consoleUriBuilder.queryParam("referrer", new Object[]{referrer});
            }
            if ((referrerUri = (String)queryParameters.getFirst((Object)"referrer_uri")) != null) {
                consoleUriBuilder.queryParam("referrer_uri", new Object[]{referrerUri});
            }
        }
        URI targetUri = consoleUriBuilder.build(new Object[]{this.realm.getName()});
        try {
            String codeVerifier = UUID.randomUUID().toString();
            pkceChallenge = PkceUtils.generateS256CodeChallenge(codeVerifier);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)OIDCLoginProtocolService.authUrl((UriInfo)this.session.getContext().getUri()).build(new Object[]{this.realm.getName()}).toString()).queryParam("client_id", new Object[]{"account-console"}).queryParam("redirect_uri", new Object[]{targetUri}).queryParam("response_type", new Object[]{"code"}).queryParam("code_challenge", new Object[]{pkceChallenge}).queryParam("code_challenge_method", new Object[]{"S256"});
        if (!queryParameters.isEmpty()) {
            String error = (String)queryParameters.getFirst((Object)"error");
            if (error != null) {
                try {
                    return this.renderAccountConsole();
                }
                catch (IOException | FreeMarkerException e) {
                    throw new ServerErrorException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            String scope = (String)queryParameters.getFirst((Object)"scope");
            if (StringUtil.isNotBlank((String)scope)) {
                uriBuilder.queryParam("scope", new Object[]{scope});
            }
        }
        URI url = uriBuilder.build(new Object[0]);
        return Response.status((int)302).location(url).build();
    }

    private Map<String, String> supportedLocales(Properties messages) {
        return this.realm.getSupportedLocalesStream().collect(Collectors.toMap(Function.identity(), l -> messages.getProperty("locale_" + l, (String)l)));
    }

    private String messagesToJsonString(Properties props) {
        if (props == null) {
            return "";
        }
        Properties newProps = new Properties();
        for (String prop : props.stringPropertyNames()) {
            newProps.put(prop, this.convertPropValue(props.getProperty(prop)));
        }
        try {
            return JsonSerialization.writeValueAsString((Object)newProps);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String convertPropValue(String propertyValue) {
        propertyValue = propertyValue.replaceAll("'('?)", "$1");
        propertyValue = this.putJavaParamsInNgTranslateFormat(propertyValue);
        return propertyValue;
    }

    private String putJavaParamsInNgTranslateFormat(String propertyValue) {
        Matcher matcher = this.bundleParamPattern.matcher(propertyValue);
        while (matcher.find()) {
            propertyValue = propertyValue.replace(matcher.group(1), "{{param_" + matcher.group(2) + "}}");
        }
        return propertyValue;
    }

    @GET
    @Path(value="index.html")
    public Response getIndexHtmlRedirect() {
        return Response.status((int)302).location(this.session.getContext().getUri().getRequestUriBuilder().path("../").build(new Object[0])).build();
    }

    private String[] getReferrer() {
        String referrer = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"referrer");
        if (referrer == null) {
            return null;
        }
        ClientModel referrerClient = this.realm.getClientByClientId(referrer);
        if (referrerClient == null) {
            return null;
        }
        String referrerUri = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"referrer_uri");
        referrerUri = referrerUri != null ? RedirectUtils.verifyRedirectUri(this.session, referrerUri, referrerClient) : ResolveRelative.resolveRelativeUri(this.session, referrerClient.getRootUrl(), referrerClient.getBaseUrl());
        if (referrerUri == null) {
            return null;
        }
        String referrerName = referrerClient.getName();
        if (Validation.isBlank(referrerName)) {
            referrerName = referrer;
        }
        return new String[]{referrer, referrerName, referrerUri};
    }
}

