/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.appdba.synonym.change.CreateSynonymChange;
import com.datical.liquibase.ext.appdba.synonym.change.DropSynonymChange;
import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import liquibase.change.Change;
import liquibase.change.core.OutputChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class ChangedSynonymChangeGenerator
extends LicenseCheckingChangeGenerator
implements ChangedObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Synonym.class.isAssignableFrom(objectType)) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        Synonym synonym = (Synonym)changedObject;
        DropSynonymChange dropChange = new DropSynonymChange();
        dropChange.setSynonymName(synonym.getName());
        dropChange.setObjectType(synonym.getObjectType());
        if (!(referenceDatabase instanceof MSSQLDatabase)) {
            dropChange.setPrivate(synonym.isPrivate());
        }
        if (control.getIncludeCatalog()) {
            dropChange.setSynonymCatalogName(synonym.getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            dropChange.setSynonymSchemaName(synonym.getSchema().getName());
        }
        CreateSynonymChange createChange = new CreateSynonymChange();
        createChange.setSynonymName(synonym.getName());
        createChange.setObjectName(synonym.getObjectName());
        boolean isPrivate = synonym.isPrivate();
        if (referenceDatabase instanceof MSSQLDatabase) {
            isPrivate = false;
        }
        createChange.setPrivate(isPrivate);
        createChange.setObjectType(synonym.getObjectType());
        if (isPrivate && synonym.getSchema() != null) {
            if (control.getIncludeCatalog()) {
                createChange.setSynonymCatalogName(synonym.getSchema().getCatalogName());
            }
            if (control.getIncludeSchema()) {
                createChange.setSynonymSchemaName(synonym.getSchema().getName());
            }
        }
        if (synonym.getObjectSchema() != null) {
            boolean schemaDifferent;
            boolean catalogDifferent = !StringUtil.trimToEmpty((String)synonym.getObjectSchema().getCatalogName()).equalsIgnoreCase(StringUtil.trimToEmpty((String)referenceDatabase.getDefaultCatalogName()));
            boolean bl = schemaDifferent = !StringUtil.trimToEmpty((String)synonym.getObjectSchema().getName()).equalsIgnoreCase(StringUtil.trimToEmpty((String)referenceDatabase.getDefaultSchemaName()));
            if (catalogDifferent || control.getIncludeCatalog()) {
                createChange.setObjectCatalogName(synonym.getObjectSchema().getCatalogName());
            }
            if (schemaDifferent || control.getIncludeSchema()) {
                createChange.setObjectSchemaName(synonym.getObjectSchema().getName());
            }
        }
        if (referenceDatabase instanceof OracleDatabase && createChange.getSynonymCatalogName() != null && createChange.getSynonymSchemaName() == null) {
            createChange.setSynonymSchemaName(createChange.getSynonymCatalogName());
            createChange.setSynonymCatalogName(null);
        }
        if (referenceDatabase instanceof OracleDatabase && createChange.getObjectCatalogName() != null && createChange.getObjectSchemaName() == null) {
            createChange.setObjectSchemaName(createChange.getObjectCatalogName());
            createChange.setObjectCatalogName(null);
        }
        if (referenceDatabase instanceof OracleDatabase && ((Boolean)changedObject.getAttribute("missingSchema", (Object)false)).booleanValue()) {
            OutputChange outputChange = new OutputChange();
            outputChange.setMessage("No schema found for the object pointed to by this synonym. This may mean it references an object across database link. Please ensure the synonym is being created correctly.");
            return new Change[]{outputChange, dropChange, createChange};
        }
        return new Change[]{dropChange, createChange};
    }
}

