/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog;

import com.datical.liquibase.ext.changelog.AbstractChangelogRewriter;
import com.datical.liquibase.ext.changelog.ChangelogRewriter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.exception.LiquibaseException;
import liquibase.util.StringUtil;

public abstract class AbstractFormattedChangelogRewriter
extends AbstractChangelogRewriter {
    public static final String LABELS = " labels:";
    public static final String CONTEXT = " context:";
    public static final String CONTEXT_FILTER = " contextFilter:";
    protected static final String FORMATTED_LABELS_REGEX = ".*labels:(\\S*).*";
    protected static final Pattern FORMATTED_LABELS_PATTERN = Pattern.compile(".*labels:(\\S*).*", 2);
    protected static final String FORMATTED_CONTEXT_REGEX = ".*context:(\".*\"|\\S*).*";
    protected static final Pattern FORMATTED_CONTEXT_PATTERN = Pattern.compile(".*context:(\".*\"|\\S*).*", 2);
    protected static final String FORMATTED_CONTEXT_FILTER_REGEX = ".*contextFilter:(\".*\"|\\S*).*";
    protected static final Pattern FORMATTED_CONTEXT_FILTER_PATTERN = Pattern.compile(".*contextFilter:(\".*\"|\\S*).*", 2);
    protected final String FORMATTED_CHANGE_SET_REGEX = String.format("\\s*%s[\\s]*changeset\\s+(\"[^\"]+\"|[^:]+):\\s*(\"[^\"]+\"|\\S+).*", this.getSingleLineCommentSequence());
    protected final Pattern FORMATTED_CHANGE_SET_PATTERN = Pattern.compile(this.FORMATTED_CHANGE_SET_REGEX, 2);
    protected final String FORMATTED_ALT_CHANGE_SET_ONE_DASH_REGEX = String.format("%s[\\s]*changeset\\s.*", this.getSingleLineCommentOneCharacter());
    protected final Pattern FORMATTED_ALT_CHANGE_SET_ONE_DASH_PATTERN = Pattern.compile(this.FORMATTED_ALT_CHANGE_SET_ONE_DASH_REGEX, 2);
    protected final String FORMATTED_ALT_CHANGE_SET_NO_OTHER_INFO_REGEX = String.format("\\s*%s[\\s]*changeset[\\s]*.*$", this.getSingleLineCommentSequence());
    protected final Pattern FORMATTED_ALT_CHANGE_SET_NO_OTHER_INFO_PATTERN = Pattern.compile(this.FORMATTED_ALT_CHANGE_SET_NO_OTHER_INFO_REGEX, 2);
    private static final String FORMATTED_DBMS_REGEX = ".*dbms:([^,][\\w!,]+).*";
    private static final Pattern FORMATTED_DBMS_PATTERN = Pattern.compile(".*dbms:([^,][\\w!,]+).*", 2);
    protected static final String FORMATTED_IGNORE_REGEX = ".*ignore:(\\w*).*";
    protected static final Pattern FORMATTED_IGNORE_PATTERN = Pattern.compile(".*ignore:(\\w*).*", 2);
    protected final String FORMATTED_ALT_IGNORE_REGEX = String.format("%s[\\s]*ignore:(\\w+)", this.getSingleLineCommentSequence());
    protected final Pattern FORMATTED_ALT_IGNORE_PATTERN = Pattern.compile(this.FORMATTED_ALT_IGNORE_REGEX, 2);

    protected abstract String getSingleLineCommentOneCharacter();

    protected abstract String getSingleLineCommentSequence();

    protected abstract String getFirstLine();

    protected abstract String getSequenceName();

    @Override
    public String handle(String changelogString) throws LiquibaseException {
        if (!changelogString.toLowerCase().contains(this.getFirstLine())) {
            throw new LiquibaseException(String.format("Changelog file '%s' is not in the formatted %s format", this.changelogFile, this.getSequenceName()));
        }
        AtomicReference<String> modifiedChangelogString = new AtomicReference<String>(changelogString);
        String[] lines = changelogString.replace("\r\n", "\n").split("\n");
        Arrays.stream(lines).forEach(line -> {
            boolean isChangeSet = this.matchForChangeset((String)line);
            if (isChangeSet && !this.isIgnored((String)line) && this.isDbmsMatch((String)line)) {
                this.modifyFormattedSequence(modifiedChangelogString, (String)line);
            }
        });
        String newChangeLogString = modifiedChangelogString.get();
        return newChangeLogString;
    }

    private boolean isIgnored(String line) {
        Matcher formattedChangeSetIgnoreMatcher = FORMATTED_IGNORE_PATTERN.matcher(line);
        boolean isIgnore = false;
        if (formattedChangeSetIgnoreMatcher.find()) {
            isIgnore = formattedChangeSetIgnoreMatcher.group(1).equalsIgnoreCase("true");
        } else {
            formattedChangeSetIgnoreMatcher = this.FORMATTED_ALT_IGNORE_PATTERN.matcher(line);
            if (formattedChangeSetIgnoreMatcher.find()) {
                isIgnore = formattedChangeSetIgnoreMatcher.group(1).equalsIgnoreCase("true");
            }
        }
        if (isIgnore) {
            String message = "Ignoring changeset '" + this.createChangeSetDisplayString(line) + "'";
            Scope.getCurrentScope().getUI().sendMessage(message);
        }
        return isIgnore;
    }

    private String createChangeSetDisplayString(String line) {
        String author;
        Matcher changeSetMatcher = this.FORMATTED_CHANGE_SET_PATTERN.matcher(line);
        if (!changeSetMatcher.find()) {
            return line;
        }
        String id = changeSetMatcher.group(2);
        if (id != null) {
            id = id.replace("\"", "");
        }
        if ((author = changeSetMatcher.group(1)) != null) {
            author = author.replace("\"", "");
        }
        String path = this.determinePath(null);
        return String.format("%s::%s::%s", id, author, path);
    }

    private boolean isDbmsMatch(String line) {
        Matcher formattedChangeSetIgnoreMatcher = FORMATTED_DBMS_PATTERN.matcher(line);
        boolean isDbmsMatch = true;
        if (formattedChangeSetIgnoreMatcher.find()) {
            String dbms = formattedChangeSetIgnoreMatcher.group(1);
            isDbmsMatch = this.databaseChangelog.isDbmsMatch(dbms);
        }
        if (!isDbmsMatch) {
            String message = "Mismatched DBMS value for changeset '" + this.createChangeSetDisplayString(line) + "'";
            Scope.getCurrentScope().getUI().sendMessage(message);
        }
        return isDbmsMatch;
    }

    private String addNewLabelsOrContexts(String changeSetString, String newValue) {
        String newChangeSetString = this.modType == ChangelogRewriter.MOD_TYPE.LABELS ? String.format("%s%s%s ", changeSetString, LABELS, newValue) : String.format("%s%s\"%s\" ", changeSetString, CONTEXT, newValue);
        return newChangeSetString;
    }

    private boolean matchForChangeset(String line) {
        Matcher formattedChangeSetMatcher = this.FORMATTED_CHANGE_SET_PATTERN.matcher(line);
        if (formattedChangeSetMatcher.find()) {
            return true;
        }
        formattedChangeSetMatcher = this.FORMATTED_ALT_CHANGE_SET_ONE_DASH_PATTERN.matcher(line);
        if (formattedChangeSetMatcher.find()) {
            return true;
        }
        formattedChangeSetMatcher = this.FORMATTED_ALT_CHANGE_SET_NO_OTHER_INFO_PATTERN.matcher(line);
        return formattedChangeSetMatcher.find();
    }

    private void modifyFormattedSequence(AtomicReference<String> modifiedChangelogString, String line) {
        Matcher matcher = this.modType == ChangelogRewriter.MOD_TYPE.LABELS ? FORMATTED_LABELS_PATTERN.matcher(line) : this.getContextsMatcher(line);
        String fileValue = null;
        if (matcher.find()) {
            fileValue = matcher.groupCount() >= 1 ? matcher.group(1) : null;
        }
        modifiedChangelogString.set(this.modifyValueInFormattedSequence(modifiedChangelogString.get(), line, fileValue));
    }

    private Matcher getContextsMatcher(String line) {
        Matcher contextMatcher = FORMATTED_CONTEXT_PATTERN.matcher(line);
        if (contextMatcher.find()) {
            contextMatcher.reset();
            return contextMatcher;
        }
        return FORMATTED_CONTEXT_FILTER_PATTERN.matcher(line);
    }

    private String modifyValueInFormattedSequence(String newChangeLogString, String changeSetString, String fileValue) {
        String newChangeSetString;
        String newValue;
        Matcher changeSetMatcher = this.FORMATTED_CHANGE_SET_PATTERN.matcher(changeSetString);
        ChangeSet changeSet = this.matchChangeSet(changeSetMatcher);
        if (changeSet == null) {
            Scope.getCurrentScope().getLog(AbstractFormattedChangelogRewriter.class).info("Unable to match changeset '" + changeSetString + "'");
            return newChangeLogString;
        }
        String string = newValue = this.modType == ChangelogRewriter.MOD_TYPE.LABELS ? changeSet.getLabels().toString() : this.createContextStringForFile(changeSet);
        if (StringUtil.isEmpty((String)newValue)) {
            return newChangeLogString;
        }
        if (fileValue == null) {
            newChangeSetString = this.addNewLabelsOrContexts(changeSetString, newValue);
        } else {
            if (fileValue.trim().equals(newValue)) {
                return newChangeLogString;
            }
            newChangeSetString = this.modType == ChangelogRewriter.MOD_TYPE.LABELS ? changeSetString.replace(LABELS + fileValue, LABELS + newValue) : (changeSetString.contains(CONTEXT_FILTER) ? changeSetString.replace(CONTEXT_FILTER + fileValue, " contextFilter:\"" + newValue + "\"") : changeSetString.replace(CONTEXT + fileValue, " context:\"" + newValue + "\""));
        }
        newChangeLogString = newChangeLogString.replace(changeSetString, newChangeSetString);
        return newChangeLogString;
    }

    private ChangeSet matchChangeSet(Matcher changeSetMatcher) {
        String author;
        if (!changeSetMatcher.find()) {
            return null;
        }
        String id = changeSetMatcher.group(2);
        if (id != null) {
            id = id.replace("\"", "");
        }
        if ((author = changeSetMatcher.group(1)) != null) {
            author = author.replace("\"", "");
        }
        String path = this.determinePath(null);
        return this.databaseChangelog.getChangeSet(path, author, id);
    }
}

