/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog;

import com.datical.liquibase.ext.changelog.ChangelogRewriter;
import java.util.ArrayList;
import java.util.List;
import liquibase.Scope;
import liquibase.SingletonObject;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.LiquibaseException;
import liquibase.servicelocator.ServiceLocator;

public class ChangelogRewriterFactory
implements SingletonObject {
    private final List<ChangelogRewriter> rewriters = new ArrayList<ChangelogRewriter>();

    private ChangelogRewriterFactory() {
        ServiceLocator serviceLocator = Scope.getCurrentScope().getServiceLocator();
        this.rewriters.addAll(serviceLocator.findInstances(ChangelogRewriter.class));
    }

    public ChangelogRewriter createChangelogRewriter(String changelogFile, DatabaseChangeLog databaseChangelog, String includedPath, ChangelogRewriter.MOD_TYPE modType) throws LiquibaseException {
        for (ChangelogRewriter rewriter : this.rewriters) {
            if (!rewriter.supports(changelogFile)) continue;
            rewriter.setChangelogFile(changelogFile);
            rewriter.setDatabaseChangelog(databaseChangelog);
            rewriter.setIncludedPath(includedPath);
            rewriter.setModType(modType);
            return rewriter;
        }
        return null;
    }
}

