/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.BasicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseBasicForecastRule;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import com.datical.liquibase.ext.util.DatabaseObjectUtils;
import java.util.Collections;
import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class TableMustHaveAnIndex
extends AbstractLiquibaseBasicForecastRule {
    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, BasicRule basicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, BasicRule basicRule) {
        if (databaseObject instanceof Table) {
            if (((Table)databaseObject).getIndexes().isEmpty()) {
                this.addFailureRuleIteration(databaseObject, String.format("Table %s found without an index, which can lead to performance issues", DatabaseObjectUtils.buildFullyQualifiedName(databaseObject)), (AbstractConfigurableRule)basicRule);
            }
        } else {
            this.addNonApplicableRuleIteration(databaseObject, String.format("Object '%s' not applicable for rule '%s'", databaseObject.getName(), basicRule.getShortName()), RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE, (AbstractConfigurableRule)basicRule);
        }
        return this.returnAtEndOfRule(databaseObject, (AbstractConfigurableRule)basicRule);
    }

    @Override
    public String getDescription() {
        return "This check scans your target URL database tables to find tables which do not have an associated index.";
    }

    @Override
    public String getShortName() {
        return "CheckTablesForIndex";
    }

    @Override
    public int getPriority() {
        return 230;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }
}

