/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;

public enum Constraint {
    NOT_NULL(table -> {
        List columns = table.getColumns();
        if (columns != null) {
            HashSet<String> columnNames = new HashSet<String>();
            for (Column column : columns) {
                if (column.isNullable().booleanValue()) continue;
                columnNames.add(column.getName());
            }
            return columnNames;
        }
        return Collections.emptySet();
    }),
    UNIQUE(table -> {
        List uniqueConstraints = table.getUniqueConstraints();
        if (uniqueConstraints != null) {
            HashSet columnNames = new HashSet();
            for (UniqueConstraint uniqueConstraint : uniqueConstraints) {
                columnNames.addAll(uniqueConstraint.getColumns().stream().map(Column::getName).collect(Collectors.toList()));
            }
            return columnNames;
        }
        return Collections.emptySet();
    }),
    PRIMARYKEY(table -> {
        PrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey != null) {
            return primaryKey.getColumns().stream().map(Column::getName).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }),
    FOREIGNKEY(table -> {
        List outgoingForeignKeys = table.getOutgoingForeignKeys();
        if (outgoingForeignKeys != null) {
            HashSet columnNames = new HashSet();
            for (ForeignKey outgoingForeignKey : outgoingForeignKeys) {
                columnNames.addAll(outgoingForeignKey.getForeignKeyColumns().stream().map(Column::getName).collect(Collectors.toSet()));
            }
            return columnNames;
        }
        return Collections.emptySet();
    }),
    DEFAULT(table -> {
        List columns = table.getColumns();
        if (columns != null) {
            HashSet<String> columnNames = new HashSet<String>();
            for (Column column : columns) {
                if (column.getDefaultValue() == null) continue;
                columnNames.add(column.getName());
            }
            return columnNames;
        }
        return Collections.emptySet();
    });

    private final Function<Table, Set<String>> getColumnNamesCallback;

    private Constraint(Function<Table, Set<String>> getColumnNamesCallback) {
        this.getColumnNamesCallback = getColumnNamesCallback;
    }

    public Set<String> getColumnNames(Table table) {
        return this.getColumnNamesCallback.apply(table);
    }
}

