/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.JSqlParserCache;
import com.datical.liquibase.ext.checks.SqlParseException;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.OperatorEnum;
import com.datical.liquibase.ext.checks.config.cli.RegexGetter;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.cli.StringEnumListGetter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.checks.dynamic.ObjectTypesEnum;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statements;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public abstract class AbstractObjectNamingRule
extends AbstractLiquibaseDynamicForecastRule {
    @Override
    public List<ScopeEnum> getScope() {
        return Arrays.asList(ScopeEnum.CHANGELOG, ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    private Boolean getCaseSensitiveParam(DynamicRule dynamicRule, OperatorEnum operator) throws Exception {
        Boolean caseSensitive = (Boolean)DynamicRuleParameterEnum.CASE_SENSITIVE.defaultValue;
        if (operator != OperatorEnum.REGEXP) {
            caseSensitive = (Boolean)dynamicRule.getParameterValue(DynamicRuleParameterEnum.CASE_SENSITIVE);
        } else if (dynamicRule.getParameter(DynamicRuleParameterEnum.CASE_SENSITIVE) != null) {
            throw new Exception("Rule is using a " + (Object)((Object)OperatorEnum.REGEXP) + " operator, but also has a value for the " + (Object)((Object)DynamicRuleParameterEnum.CASE_SENSITIVE) + " param.");
        }
        return caseSensitive;
    }

    private List<ObjectTypesEnum> getObjectTypesParam(DynamicRule dynamicRule) {
        return StringEnumListGetter.split((String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.OBJECT_TYPES), ObjectTypesEnum.class, true);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        return this.doEvaluate(changeSet.getChanges(), changeSet, dynamicRule, false);
    }

    private boolean doEvaluate(List<Change> changes, ChangeSet changeSet, DynamicRule dynamicRule, boolean isRollback) {
        OperatorEnum operator = dynamicRule.getEnumParameterValue(DynamicRuleParameterEnum.OPERATOR, OperatorEnum.class);
        String searchString = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.SEARCH_STRING);
        Boolean caseSensitive = (Boolean)DynamicRuleParameterEnum.CASE_SENSITIVE.defaultValue;
        try {
            caseSensitive = this.getCaseSensitiveParam(dynamicRule, operator);
        }
        catch (Exception e) {
            this.putResultUnsuccessful(changeSet, e.getMessage(), dynamicRule, isRollback);
        }
        List<ObjectTypesEnum> objectTypes = this.getObjectTypesParam(dynamicRule);
        boolean typeMatched = false;
        for (Change change : changes) {
            for (ObjectTypesEnum objectType : objectTypes) {
                List<String> returnValues;
                ArrayList<String> valuesToCompare = new ArrayList<String>();
                if (change instanceof AbstractSQLChange && this.shouldParseSql()) {
                    try {
                        String[] splitSqls;
                        for (String splitSql : splitSqls = StringUtil.splitSQL((String)StringUtil.stripComments((String)AbstractObjectNamingRule.getSql((AbstractSQLChange)change), (ChangeSet)changeSet), (String)((AbstractSQLChange)change).getEndDelimiter(), (ChangeSet)changeSet)) {
                            Statements statements = JSqlParserCache.parseSql(splitSql, true);
                            ArrayList<String> names = new ArrayList<String>();
                            for (Statement statement : statements.getStatements()) {
                                names.addAll((Collection<String>)objectType.sqlCallback.apply(statement));
                            }
                            if (names.isEmpty() || !this.notAllEmpty(names)) continue;
                            valuesToCompare.addAll(names.stream().map(AbstractObjectNamingRule::cleanseQuotes).collect(Collectors.toList()));
                        }
                    }
                    catch (SqlParseException e) {
                        Level level = (Level)Scope.getCurrentScope().get(ChecksRunCommandStep.SQL_PARSE_EXCEPTION_LOG_AT_LEVEL_ARG.getName(), (Object)Level.FINE);
                        Scope.getCurrentScope().getLog(this.getClass()).log(level, "Failed to parse SQL", (Throwable)e);
                        this.addFailureRuleIteration(changeSet, "Some or all of the SQL could not be parsed by this check. Please review the changeset or SQL directly to make sure it is valid.", RuleIteration.FailureReason.SQL_PARSING, (AbstractConfigurableRule)dynamicRule, isRollback);
                    }
                } else if (change instanceof AbstractChange && (returnValues = objectType.abstractChangeCallback.apply((AbstractChange)change)) != null && this.notAllEmpty(returnValues)) {
                    valuesToCompare.addAll(returnValues);
                }
                for (String valueToCompare : valuesToCompare) {
                    typeMatched = true;
                    boolean matches = operator.matches(searchString, valueToCompare, caseSensitive);
                    if (!this.operatorMatchCallback(matches)) continue;
                    this.addFailureRuleIteration(changeSet, this.getFailureMessage(objectType, operator, searchString, "the indicated changeset", valueToCompare), dynamicRule, isRollback);
                }
            }
        }
        if (!typeMatched) {
            this.addNonApplicableRuleIteration(changeSet, String.format("Changeset '%s' not applicable for rule '%s'", changeSet.toString(), dynamicRule.getShortName()), RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE, (AbstractConfigurableRule)dynamicRule);
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, isRollback);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, Database database, DynamicRule dr) {
        return this.doEvaluate(changes, changeSet, dr, true);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        OperatorEnum operator = dynamicRule.getEnumParameterValue(DynamicRuleParameterEnum.OPERATOR, OperatorEnum.class);
        String searchString = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.SEARCH_STRING);
        Boolean caseSensitive = (Boolean)DynamicRuleParameterEnum.CASE_SENSITIVE.defaultValue;
        try {
            caseSensitive = this.getCaseSensitiveParam(dynamicRule, operator);
        }
        catch (Exception e) {
            this.putResultUnsuccessful(databaseObject, e.getMessage(), (AbstractConfigurableRule)dynamicRule);
        }
        List<ObjectTypesEnum> objectTypes = this.getObjectTypesParam(dynamicRule);
        boolean typeMatched = false;
        for (ObjectTypesEnum objectType : objectTypes) {
            ArrayList<String> valuesToCompare = new ArrayList<String>(1);
            valuesToCompare.addAll(objectType.getNamesFromDatabaseObject(databaseObject));
            for (String valueToCompare : valuesToCompare) {
                typeMatched = true;
                boolean matches = operator.matches(searchString, valueToCompare, caseSensitive);
                if (!this.operatorMatchCallback(matches)) continue;
                this.addFailureRuleIteration(databaseObject, this.getFailureMessage(objectType, operator, searchString, "this database object", valueToCompare), (AbstractConfigurableRule)dynamicRule);
            }
        }
        if (!typeMatched) {
            this.addNonApplicableRuleIteration(databaseObject, String.format("Object '%s' not applicable for rule '%s'", databaseObject.getName(), dynamicRule.getShortName()), RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE, (AbstractConfigurableRule)dynamicRule);
        }
        return this.returnAtEndOfRule(databaseObject, (AbstractConfigurableRule)dynamicRule);
    }

    public boolean shouldParseSql() {
        return true;
    }

    private boolean notAllEmpty(List<String> listToCheck) {
        return listToCheck.stream().noneMatch(StringUtil::isEmpty);
    }

    public abstract boolean operatorMatchCallback(boolean var1);

    public abstract String getFailureMessage(ObjectTypesEnum var1, OperatorEnum var2, String var3, String var4, String var5);

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.OPERATOR), new RuleParameter<String>(DynamicRuleParameterEnum.SEARCH_STRING, (value, newParameterValues) -> {
            Optional<DynamicRuleParameter> operatorParamOpt = newParameterValues.stream().filter(pv -> pv.getParameterAsEnum() == DynamicRuleParameterEnum.OPERATOR).findFirst();
            DynamicRuleParameter operatorParam = operatorParamOpt.get();
            if (operatorParam.getValue() == OperatorEnum.REGEXP) {
                return new RegexGetter().validate((String)value);
            }
            if (StringUtil.isEmpty((String)value)) {
                throw new IllegalArgumentException("The search string is empty or contains invalid characters.");
            }
            return true;
        }, null), new RuleParameter(DynamicRuleParameterEnum.OBJECT_TYPES), new RuleParameter(DynamicRuleParameterEnum.CASE_SENSITIVE, null, newParameterValues -> {
            Optional<DynamicRuleParameter> operatorParamOpt = newParameterValues.stream().filter(pv -> pv.getParameterAsEnum() == DynamicRuleParameterEnum.OPERATOR).findFirst();
            DynamicRuleParameter operatorParam = operatorParamOpt.get();
            Object operator = operatorParam.getValue() instanceof String ? OperatorEnum.valueOf((String)operatorParam.getValue()) : operatorParam.getValue();
            return operator != OperatorEnum.REGEXP;
        }));
    }

    private static String cleanseQuotes(String objectName) {
        List<String> startQuotes = Arrays.asList("\"", "[", "`");
        List<String> endQuotes = Arrays.asList("\"", "]", "`");
        String newTableName = objectName;
        for (String startQuote : startQuotes) {
            if (!objectName.startsWith(startQuote)) continue;
            newTableName = newTableName.substring(startQuote.length());
            break;
        }
        for (String endQuote : endQuotes) {
            if (!objectName.endsWith(endQuote)) continue;
            newTableName = newTableName.substring(0, newTableName.length() - endQuote.length());
            break;
        }
        return newTableName;
    }
}

